/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.UnsupportedDataTypeException;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Div;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.Not;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.ILocationExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Greater;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.GreaterEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.IComparisonExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Less;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IBinaryOperator;
import org.fortiss.af3.exploration.dseml.model.expression.IBinderExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IUnaryOperator;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.Deploy;
import org.fortiss.af3.exploration.dseml.model.function.End;
import org.fortiss.af3.exploration.dseml.model.function.IFunction;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.MasterActive;
import org.fortiss.af3.exploration.dseml.model.function.MaxTime;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledSignal;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledTask;
import org.fortiss.af3.exploration.dseml.model.function.Start;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.dseml.model.function.Uses;
import org.fortiss.af3.exploration.dseml.model.function.Weight;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.af3.exploration.smt.util.SMTTransformationUtils;
import org.fortiss.af3.exploration.util.DSMLUtils;
import org.fortiss.tooling.base.model.element.IModelElement;

public class DefaultExpressionTransformator
extends ExpressionTransformator {
    public DefaultExpressionTransformator(ConstraintTransformationAdapter cta) {
        super(cta);
    }

    @Override
    public Expr transform(IExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        if (expression instanceof IBooleanExpression) {
            return this.toSMTBoolean((IBooleanExpression)expression, modelElements);
        }
        if (expression instanceof IFunction) {
            return this.toSMTFunction((IFunction)expression, modelElements);
        }
        if (expression instanceof IArithmeticExpression) {
            return this.toSMTArithmetic((IArithmeticExpression)expression, modelElements);
        }
        if (expression instanceof ModelElementLiteral) {
            return this.toModelLiteral((ModelElementLiteral)expression, modelElements);
        }
        throw new UnsupportedDataTypeException("Unknown expression " + expression.getClass().getSimpleName());
    }

    private Expr toSMTArithmetic(IArithmeticExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        if (expression instanceof IBinaryOperator) {
            Expr left = this.cta.transform(((IBinaryOperator)expression).getLeft(), modelElements);
            Expr right = this.cta.transform(((IBinaryOperator)expression).getRight(), modelElements);
            if (expression instanceof Plus) {
                return Z3javaAPIWrapper.createAddition((Context)this.context, (Expr[])new Expr[]{left, right});
            }
            if (expression instanceof Minus) {
                return Z3javaAPIWrapper.createSubtraction((Context)this.context, (Expr)left, (Expr)right);
            }
            if (expression instanceof Div) {
                return Z3javaAPIWrapper.createDivision((Context)this.context, (Expr)left, (Expr)right);
            }
            if (expression instanceof Mul) {
                return Z3javaAPIWrapper.createMultiplication((Context)this.context, (Expr)left, (Expr)right);
            }
        } else {
            if (expression instanceof ArithmeticPropertyLiteral) {
                return this.getZ3Function((ArithmeticPropertyLiteral)expression, modelElements);
            }
            if (expression instanceof ArithmeticLiteral) {
                String string = ((ArithmeticLiteral)expression).getValue().toString();
                return Z3javaAPIWrapper.createReal((Context)this.context, (String)string);
            }
        }
        throw new UnsupportedOperationException("There is no arithmetic expression '" + expression.getClass().getSimpleName() + "' implemented.");
    }

    private <S extends IModelElement> ArithExpr getZ3Function(ArithmeticPropertyLiteral<S, ? extends Number> arithExpr, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        String name = SMTTransformationUtils.getFunctionName(arithExpr);
        Set setReference = arithExpr.getSetReference();
        SuperSet superSetReference = setReference.getSuperSetReference();
        Collection matchingMEs = modelElements.values().stream().filter(me -> setReference.getEntryType().isAssignableFrom(me.getClass())).collect(Collectors.toList());
        boolean isReal = true;
        if (!matchingMEs.isEmpty()) {
            boolean isRealTmp;
            isReal = isRealTmp = matchingMEs.stream().map(me -> (Number)arithExpr.getValue((IModelElement)me)).anyMatch(value -> DSMLUtils.isReal((Number)value));
        }
        EnumSort inputSort = this.transformationService.getExistingSorts().get(superSetReference);
        RealSort outputSort = isReal ? this.context.getRealSort() : this.context.getIntSort();
        FuncDecl function = Z3javaAPIWrapper.createFunction((Context)this.context, (String)name, (Sort)inputSort, (Sort)outputSort);
        return (ArithExpr)function.apply(this.getLiteralExpr(modelElements, new IExpression[]{arithExpr}));
    }

    private Expr toSMTBoolean(IBooleanExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        if (expression instanceof StronglyCausal) {
            return this.toSMTFunction((IFunction)((StronglyCausal)expression), modelElements);
        }
        if (expression instanceof MasterActive) {
            return this.toSMTFunction((IFunction)((MasterActive)expression), modelElements);
        }
        if (expression instanceof IsTask) {
            return this.toSMTFunction((IFunction)((IsTask)expression), modelElements);
        }
        if (expression instanceof Uses) {
            return this.toSMTFunction((IFunction)((Uses)expression), modelElements);
        }
        if (expression instanceof IBinaryOperator) {
            if (expression instanceof ILocationExpression) {
                return this.createLocationExpression((ILocationExpression)expression, modelElements);
            }
            Expr left = this.cta.transform(((IBinaryOperator)expression).getLeft(), modelElements);
            Expr right = this.cta.transform(((IBinaryOperator)expression).getRight(), modelElements);
            if (expression instanceof IComparisonExpression) {
                return this.createComparisonExpression((IComparisonExpression)expression, left, right);
            }
            if (expression instanceof And) {
                return Z3javaAPIWrapper.createAnd((Context)this.context, (BoolExpr[])new BoolExpr[]{(BoolExpr)left, (BoolExpr)right});
            }
            if (expression instanceof Or) {
                return Z3javaAPIWrapper.createOr((Context)this.context, (BoolExpr[])new BoolExpr[]{(BoolExpr)left, (BoolExpr)right});
            }
            if (expression instanceof Implies) {
                return Z3javaAPIWrapper.createImplication((Context)this.context, (BoolExpr)((BoolExpr)left), (BoolExpr)((BoolExpr)right));
            }
        } else if (expression instanceof IUnaryOperator) {
            Expr right = this.cta.transform(((IUnaryOperator)expression).getRight(), modelElements);
            if (expression instanceof Not) {
                return Z3javaAPIWrapper.createNot((Context)this.context, (BoolExpr)((BoolExpr)right));
            }
        } else if (expression instanceof BooleanLiteral) {
            return Z3javaAPIWrapper.createBoolean((Context)this.context, (boolean)((BooleanLiteral)expression).isValue());
        }
        throw new UnsupportedOperationException("There is no boolean expression '" + expression.getClass().getSimpleName() + "' implemented.");
    }

    private Expr toModelLiteral(ModelElementLiteral expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        return this.getLiteralExpr(modelElements, new IExpression[]{expression})[0];
    }

    private Expr toSMTFunction(IFunction function, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException {
        if (function instanceof Start) {
            return this.transformationService.getZ3FunctionDecl((Start)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((Start)function).getArgs()}));
        }
        if (function instanceof End) {
            return this.transformationService.getZ3FunctionDecl((End)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((End)function).getArgs()}));
        }
        if (function instanceof Weight) {
            return this.transformationService.getZ3FunctionDecl((Weight)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((Weight)function).getArg0()}));
        }
        if (function instanceof FrequencyAssigned) {
            return this.transformationService.getZ3FunctionDecl((FrequencyAssigned)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((FrequencyAssigned)function).getArg0()}));
        }
        if (function instanceof MaxTime) {
            return this.transformationService.getZ3Function((MaxTime)function);
        }
        if (function instanceof ScheduledSignal) {
            return this.transformationService.getZ3FunctionDecl((ScheduledSignal)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((ScheduledSignal)function).getArgs()}));
        }
        if (function instanceof ScheduledTask) {
            return this.transformationService.getZ3FunctionDecl((ScheduledTask)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((ScheduledTask)function).getArgs()}));
        }
        if (function instanceof StronglyCausal) {
            return this.transformationService.getZ3FunctionDecl((StronglyCausal)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((StronglyCausal)function).getArg0()}));
        }
        if (function instanceof MasterActive) {
            MasterActive masterActive = (MasterActive)function;
            ModelElementLiteral task = masterActive.getTask();
            ModelElementLiteral fs = masterActive.getFs();
            return this.transformationService.getZ3FunctionDecl(masterActive).apply(this.getLiteralExpr(modelElements, new IExpression[]{task, fs}));
        }
        if (function instanceof Deploy) {
            Deploy dply = (Deploy)function;
            Expr[] expr = this.getLiteralExpr(modelElements, new IExpression[]{dply.getTask(), dply.getEcu(), dply.getFs()});
            return this.transformationService.getZ3FunctionDecl(dply).apply(new Expr[]{expr[0], expr[1], expr[2]});
        }
        if (function instanceof IsTask) {
            return this.transformationService.getZ3FunctionDecl((IsTask)function).apply(this.getLiteralExpr(modelElements, new IExpression[]{((IsTask)function).getArg0()}));
        }
        if (function instanceof Uses) {
            return this.transformationService.getZ3FunctionDecl((Uses)function).apply(this.getLiteralExpr(modelElements, (IExpression[])new ModelElementLiteral[]{((Uses)function).getArg0(), ((Uses)function).getArg1()}));
        }
        throw new UnsupportedDataTypeException("The type " + function.getClass().getSimpleName() + " is not implemented yet.");
    }

    private BoolExpr createComparisonExpression(IComparisonExpression<?> expression, Expr left, Expr right) {
        if (expression instanceof Greater) {
            return Z3javaAPIWrapper.createGreater((Context)this.context, (Expr)left, (Expr)right);
        }
        if (expression instanceof GreaterEqual) {
            return Z3javaAPIWrapper.createGreaterEqual((Context)this.context, (Expr)left, (Expr)right);
        }
        if (expression instanceof Equal) {
            return Z3javaAPIWrapper.createEqual((Context)this.context, (Expr)left, (Expr)right);
        }
        if (expression instanceof NotEqual) {
            BoolExpr equal = Z3javaAPIWrapper.createEqual((Context)this.context, (Expr)left, (Expr)right);
            return Z3javaAPIWrapper.createNot((Context)this.context, (BoolExpr)equal);
        }
        if (expression instanceof LessEqual) {
            return Z3javaAPIWrapper.createSmallerEqual((Context)this.context, (Expr)left, (Expr)right);
        }
        if (expression instanceof Less) {
            return Z3javaAPIWrapper.createSmaller((Context)this.context, (Expr)left, (Expr)right);
        }
        throw new UnsupportedOperationException("There is no comparison expression '" + expression.getClass().getSimpleName() + "' implemented.");
    }

    private BoolExpr createLocationExpression(ILocationExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException {
        ModelElementLiteral leftModel = (ModelElementLiteral)expression.getLeft();
        ModelElementLiteral rightModel = (ModelElementLiteral)expression.getRight();
        EnumSort leftSort = this.transformationService.getSort(leftModel.getSetReference());
        EnumSort rightSort = this.transformationService.getSort(rightModel.getSetReference());
        Expr[] exprs = this.getLiteralExpr(modelElements, new IExpression[]{leftModel, rightModel});
        if (expression instanceof Allocation) {
            return this.createAllocationExpression(exprs[0], leftSort, exprs[1], rightSort);
        }
        return this.createDislocationExpression(exprs[0], leftSort, exprs[1], rightSort);
    }

    private BoolExpr createDislocationExpression(Expr leftElement, EnumSort leftSort, Expr rightElement, EnumSort rightSort) {
        BoolExpr allocation = this.createAllocationExpression(leftElement, leftSort, rightElement, rightSort);
        return Z3javaAPIWrapper.createNot((Context)this.context, (BoolExpr)allocation);
    }

    private BoolExpr createAllocationExpression(Expr leftElement, EnumSort leftSort, Expr rightElement, EnumSort rightSort) {
        FuncDecl allocate = this.transformationService.getAllocateFunction(leftSort, rightSort);
        Expr apply = allocate.apply(new Expr[]{leftElement});
        return Z3javaAPIWrapper.createEqual((Context)this.context, (Expr)apply, (Expr)rightElement);
    }

    @Override
    public boolean isApplicableTo(IExpression expression) {
        return !(expression instanceof IBinderExpression);
    }
}

