/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.IFunction;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledTask;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.util.ConstraintDefinitionUtils;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.platform.hierarchic.model.tile.Tile;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.annotation.PowerConsumption;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.Task;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;

public class EnergyConstraintDefinition {
    public static final int TRANSMISSION_CONSUMPTION = 1;
    public static final long STD_FREQ = 500L;

    public static Minimize createMinimizeConsumptionObjective(SuperSet<ResourceAllocation> resAllocSS, SuperSet<Task> taskSS, SuperSet<ExecutionUnit> ecuSS) {
        Set ecuSet = DSMLModelElementFactory.createSet(ecuSS, (Collection)ecuSS.getEntries(), (String)"aECU", ExecutionUnit.class);
        Set raSet = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"bResAlloc", ResourceAllocation.class);
        Set raSet2 = DSMLModelElementFactory.createSet(resAllocSS, (Collection)resAllocSS.getEntries(), (String)"dResAlloc", ResourceAllocation.class);
        Set taskSet = DSMLModelElementFactory.createSet(taskSS, (Collection)taskSS.getEntries(), (String)"cTask", Task.class);
        FrequencyAssigned frequencyEcu = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet);
        FrequencyAssigned frequencyEcuCopy = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet);
        Mul dynamicPowerConsumption = DSMLModelElementFactory.createMul((IArithmeticExpression)frequencyEcu, (IArithmeticExpression)frequencyEcuCopy);
        ArithmeticPropertyLiteral duration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet);
        ScheduledTask elem = ConstraintDefinitionUtils.createScheduledTask(raSet, taskSet);
        ModelElementLiteral ent = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet);
        Equal scheduled = DSMLModelElementFactory.createEquals((IExpression)elem, (IExpression)ent);
        Equal istask = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet, true);
        And conditionOnRA = DSMLModelElementFactory.createAnd((IBooleanExpression)scheduled, (IBooleanExpression)istask);
        Sum sumOverRA = DSMLModelElementFactory.createSum((Set)raSet.getCastedSet(IModelElement.class), (IBooleanExpression)conditionOnRA, (IArithmeticExpression)duration);
        ModelElementLiteral task = DSMLModelElementFactory.createModelElementLiteral((Set)taskSet);
        ModelElementLiteral ecu = DSMLModelElementFactory.createModelElementLiteral((Set)ecuSet);
        Allocation conditionOnTasks = DSMLModelElementFactory.createAllocation((ModelElementLiteral)task, (ModelElementLiteral)ecu);
        Sum activeTime = DSMLModelElementFactory.createSum((Set)taskSet.getCastedSet(IModelElement.class), (IBooleanExpression)conditionOnTasks, (IArithmeticExpression)sumOverRA);
        Mul dynamicConsumption = DSMLModelElementFactory.createMul((IArithmeticExpression)activeTime, (IArithmeticExpression)dynamicPowerConsumption);
        BooleanLiteral trivialCondition = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
        Sum ecuConsumption = DSMLModelElementFactory.createSum((Set)ecuSet.getCastedSet(IModelElement.class), (IBooleanExpression)trivialCondition, (IArithmeticExpression)dynamicConsumption);
        ArithmeticLiteral transmissionUnitConsumption = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal(1));
        ArithmeticPropertyLiteral transmissionDuration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)raSet2);
        Mul signalConsumption = DSMLModelElementFactory.createMul((IArithmeticExpression)transmissionDuration, (IArithmeticExpression)transmissionUnitConsumption);
        Equal isTask = ConstraintDefinitionUtils.defineIsTask((Set<ResourceAllocation>)raSet2, false);
        Sum transmissionConsumption = DSMLModelElementFactory.createSum((Set)raSet2.getCastedSet(IModelElement.class), (IBooleanExpression)isTask, (IArithmeticExpression)signalConsumption);
        Plus globalConsumption = DSMLModelElementFactory.createPlus((IArithmeticExpression)ecuConsumption, (IArithmeticExpression)transmissionConsumption);
        return DSMLModelElementFactory.createMinimize((IArithmeticExpression)globalConsumption);
    }

    public static Minimize createMinimizeSumObjective(SuperSet<ResourceAllocation> resAllocSS) {
        Set set = DSMLModelElementFactory.createSet(resAllocSS, (String)"aResourceAllocationsSet", ResourceAllocation.class);
        for (ResourceAllocation ra : resAllocSS.getEntries()) {
            if (!(ra.getSchedulableEntity().getModelElement() instanceof Task)) continue;
            set.getEntries().add((Object)ra);
        }
        ArithmeticPropertyLiteral startTime = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)set);
        ArithmeticPropertyLiteral durationTime = ExplorationTimingConstraintUtils.createDurationLiteral((Set)set);
        Plus endTime = DSMLModelElementFactory.createPlus((IArithmeticExpression)startTime, (IArithmeticExpression)durationTime);
        BooleanLiteral trivialCondition = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
        Sum sum = DSMLModelElementFactory.createSum((Set)set.getCastedSet(IModelElement.class), (IBooleanExpression)trivialCondition, (IArithmeticExpression)endTime);
        return DSMLModelElementFactory.createMinimize((IArithmeticExpression)sum);
    }

    public static List<IFunction> createMinimizeOverallTimeMultiObjective(SuperSet<ResourceAllocation> resAllocSS) {
        ArrayList<IFunction> objectives = new ArrayList<IFunction>();
        for (ResourceAllocation ra : resAllocSS.getEntries()) {
            Set set = DSMLModelElementFactory.createSet(resAllocSS, (String)"aResourceAllocation", ResourceAllocation.class);
            set.getEntries().add((Object)ra);
            ArithmeticPropertyLiteral startSet = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)set);
            BooleanLiteral trivialCondition = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
            Sum sum = DSMLModelElementFactory.createSum((Set)set.getCastedSet(IModelElement.class), (IBooleanExpression)trivialCondition, (IArithmeticExpression)startSet);
            Minimize minimum = DSMLModelElementFactory.createMinimize((IArithmeticExpression)sum);
            objectives.add((IFunction)minimum);
        }
        return objectives;
    }

    public static List<? extends IBooleanExpression> createFrequencyConstraints(SuperSet<ExecutionUnit> ecuSS) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        for (ExecutionUnit ecu : ecuSS.getEntries()) {
            List<Long> admissibleFreq = ConstraintDefinitionUtils.getAdmissibleFrequencies(ecu);
            Set ecuSet = DSMLModelElementFactory.createSet(ecuSS, (String)"aECU", ExecutionUnit.class);
            ecuSet.getEntries().add((Object)ecu);
            boolean firstValue = true;
            Equal formula = null;
            for (Long value : admissibleFreq) {
                FrequencyAssigned fa = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet);
                ArithmeticLiteral val = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal(value));
                Equal equals = DSMLModelElementFactory.createEquals((IExpression)fa, (IExpression)val);
                if (firstValue) {
                    firstValue = false;
                    formula = equals;
                    continue;
                }
                formula = DSMLModelElementFactory.createOr(formula, (IBooleanExpression)equals);
            }
            ForAll forAll = DSMLModelElementFactory.createForAll((Set)ecuSet, formula, (boolean)true);
            assertions.add(forAll);
        }
        return assertions;
    }

    public static List<? extends IBooleanExpression> createTileFrequencyConstraints(SuperSet<ExecutionUnit> ecuSS) {
        ArrayList<And> assertions = new ArrayList<And>();
        EList ecuList = ecuSS.getEntries();
        ArrayList<Tile> alreadySeen = new ArrayList<Tile>();
        And formula = null;
        Boolean firstRound = true;
        for (ExecutionUnit ecu : ecuList) {
            Tile tile;
            IHierarchicElementContainer container = ecu.getContainer();
            if (!(container instanceof Tile) || alreadySeen.contains(tile = (Tile)ecu.getContainer())) continue;
            alreadySeen.add(tile);
            ArrayList<ExecutionUnit> ecusInTheTile = new ArrayList<ExecutionUnit>();
            for (ExecutionUnit ecu1 : ecuList) {
                if (ecu1.getContainer() != tile) continue;
                ecusInTheTile.add(ecu1);
            }
            Set ecuSet1 = DSMLModelElementFactory.createSet(ecuSS, (String)"aECU", ExecutionUnit.class);
            ecuSet1.getEntries().addAll(ecusInTheTile);
            Set ecuSet2 = DSMLModelElementFactory.createSet(ecuSS, (String)"bECU", ExecutionUnit.class);
            ecuSet2.getEntries().addAll(ecusInTheTile);
            FrequencyAssigned fa1 = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet1);
            FrequencyAssigned fa2 = ConstraintDefinitionUtils.createFrequencyAssigned((Set<ExecutionUnit>)ecuSet2);
            Equal equals = DSMLModelElementFactory.createEquals((IExpression)fa1, (IExpression)fa2);
            ForAll forAll1 = DSMLModelElementFactory.createForAll((Set)ecuSet1, (IBooleanExpression)equals, (boolean)true);
            ForAll forAll2 = DSMLModelElementFactory.createForAll((Set)ecuSet2, (IBooleanExpression)forAll1, (boolean)true);
            if (firstRound.booleanValue()) {
                firstRound = false;
                formula = forAll2;
                continue;
            }
            formula = DSMLModelElementFactory.createAnd(formula, (IBooleanExpression)forAll2);
        }
        if (formula != null) {
            assertions.add(formula);
        }
        return assertions;
    }

    public static List<? extends IBooleanExpression> createPowerConsumptionConstraints(SuperSet<ExecutionUnit> ecuSS) {
        ArrayList<ForAll> assertions = new ArrayList<ForAll>();
        for (ExecutionUnit ecu : ecuSS.getEntries()) {
            Set ecuSet = DSMLModelElementFactory.createSet(ecuSS, (IModelElement)ecu, (String)"aECU", ExecutionUnit.class);
            ArithmeticPropertyLiteral<ExecutionUnit, Number> powerConsumptionLiteral = ConstraintDefinitionUtils.createPowerConsumptionLiteral((Set<ExecutionUnit>)ecuSet);
            PowerConsumption powerConsumption = (PowerConsumption)AnnotationUtils.getAnnotation((IModelElement)ecu, PowerConsumption.class);
            ArithmeticLiteral powerConsumptionValue = DSMLModelElementFactory.createArithmeticLiteral((BigDecimal)new BigDecimal(powerConsumption.getPower()));
            Equal equality = DSMLModelElementFactory.createEquals(powerConsumptionLiteral, (IExpression)powerConsumptionValue);
            ForAll formula = DSMLModelElementFactory.createForAll((Set)ecuSet, (IBooleanExpression)equality, (boolean)true);
            assertions.add(formula);
        }
        return assertions;
    }
}

