/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Z3Exception;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.function.IFunction;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.IDSMLTransformationService;
import org.fortiss.tooling.base.model.element.IModelElement;

public abstract class ExpressionTransformator {
    protected Context context;
    protected IDSMLTransformationService transformationService;
    protected ConstraintTransformationAdapter cta;

    protected ExpressionTransformator(ConstraintTransformationAdapter cta) {
        this.cta = cta;
        this.context = cta.getContext();
        this.transformationService = cta.getTransformationService();
    }

    public abstract boolean isApplicableTo(IExpression var1);

    public abstract Expr transform(IExpression var1, Map<Set<IModelElement>, IModelElement> var2) throws UnsupportedDataTypeException, Z3Exception;

    protected Expr[] getLiteralExpr(Map<Set<IModelElement>, IModelElement> modelElements, IExpression ... literals) throws UnsupportedDataTypeException, Z3Exception {
        Expr[] expressions = new Expr[literals.length];
        int i = 0;
        IExpression[] iExpressionArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expression;
            IExpression literal = iExpressionArray[n2];
            if (literal instanceof IFunction) {
                expression = this.cta.transform(literal, modelElements);
            } else if (literal instanceof ModelElementLiteral) {
                setReference = ((ModelElementLiteral)literal).getSetReference();
                expression = modelElements.containsKey(setReference) ? this.transformationService.getModelElementInstance(modelElements.get(setReference)) : this.transformationService.getZ3SetSymbol(setReference);
            } else if (literal instanceof ArithmeticPropertyLiteral) {
                setReference = ((ArithmeticPropertyLiteral)literal).getSetReference();
                expression = modelElements.containsKey(setReference) ? this.transformationService.getModelElementInstance(modelElements.get(setReference)) : this.transformationService.getZ3SetSymbol(setReference);
            } else {
                throw new UnsupportedDataTypeException(literal.getClass().getSimpleName() + " is not a literal.");
            }
            expressions[i++] = expression;
            ++n2;
        }
        return expressions;
    }
}

