/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.Exists;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IQuantifierExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.tooling.base.model.element.IModelElement;

public class NonQuantifiedExpressionTransformator
extends ExpressionTransformator {
    protected NonQuantifiedExpressionTransformator(ConstraintTransformationAdapter cta) {
        super(cta);
    }

    @Override
    public Expr transform(IExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        if (expression instanceof IQuantifierExpression) {
            return this.toQuantifier((IQuantifierExpression)expression, modelElements);
        }
        if (expression instanceof Sum) {
            return this.toSum((Sum)expression, modelElements);
        }
        throw new UnsupportedOperationException("The expression '" + expression.getClass().getSimpleName() + "' is not implemented.");
    }

    private Expr toQuantifier(IQuantifierExpression binder, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        ArrayList<BoolExpr> expressions = new ArrayList<BoolExpr>();
        for (IModelElement modelElement : binder.getSet().getEntries()) {
            modelElements.put((Set<IModelElement>)binder.getSet(), modelElement);
            BoolExpr expr = (BoolExpr)this.cta.transform((IExpression)binder.getExpression(), modelElements);
            expressions.add(expr);
        }
        if (binder instanceof ForAll) {
            return Z3javaAPIWrapper.createAnd((Context)this.context, expressions);
        }
        if (binder instanceof Exists) {
            return Z3javaAPIWrapper.createOr((Context)this.context, expressions);
        }
        throw new UnsupportedOperationException("There is no quantifier expression '" + binder.getClass().getSimpleName() + "' implemented.");
    }

    private Expr toSum(Sum sum, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        ArrayList<Expr> expressions = new ArrayList<Expr>();
        for (IModelElement modelElement : sum.getSet().getEntries()) {
            modelElements.put((Set<IModelElement>)sum.getSet(), modelElement);
            Expr arithTerms = this.cta.transform((IExpression)sum.getTerms(), modelElements);
            BoolExpr predicate = (BoolExpr)this.cta.transform((IExpression)sum.getExpression(), modelElements);
            IntNum zero = Z3javaAPIWrapper.createInteger((Context)this.context, (int)0);
            Expr expr = Z3javaAPIWrapper.createIfThenElse((Context)this.context, (BoolExpr)predicate, (Expr)arithTerms, (Expr)zero);
            expressions.add(expr);
        }
        return Z3javaAPIWrapper.createAddition((Context)this.context, expressions);
    }

    @Override
    public boolean isApplicableTo(IExpression expression) {
        boolean isUnfoldedQuantifier;
        boolean isSum = expression instanceof Sum;
        boolean bl = isUnfoldedQuantifier = expression instanceof IQuantifierExpression && ((IQuantifierExpression)expression).isUnfold();
        return isSum || isUnfoldedQuantifier;
    }
}

