/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.modeltransformation;

import com.microsoft.z3.Expr;
import com.microsoft.z3.Z3Exception;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.Exists;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IQuantifierExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.smt.modeltransformation.ConstraintTransformationAdapter;
import org.fortiss.af3.exploration.smt.modeltransformation.ExpressionTransformator;
import org.fortiss.tooling.base.model.element.IModelElement;

public class QuantifiedExpressionTransformator
extends ExpressionTransformator {
    public QuantifiedExpressionTransformator(ConstraintTransformationAdapter cta) {
        super(cta);
    }

    @Override
    public Expr transform(IExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        if (expression instanceof ForAll || expression instanceof Exists) {
            return this.toSMTQuantor((IQuantifierExpression)expression, modelElements);
        }
        throw new UnsupportedDataTypeException("Unknown expression " + expression.getClass().getSimpleName());
    }

    private Expr toSMTQuantor(IQuantifierExpression expression, Map<Set<IModelElement>, IModelElement> modelElements) throws UnsupportedDataTypeException, Z3Exception {
        Expr body = this.cta.transform((IExpression)expression.getExpression(), modelElements);
        Expr expr = this.transformationService.getZ3SetSymbol(expression.getSet());
        Expr[] boundSorts = new Expr[]{expr};
        if (expression instanceof ForAll) {
            return this.context.mkForall(boundSorts, body, 1, null, null, null, null);
        }
        if (expression instanceof Exists) {
            return this.context.mkExists(boundSorts, body, 1, null, null, null, null);
        }
        throw new UnsupportedOperationException("There is no quantor expression '" + expression.getClass().getSimpleName() + "' implemented.");
    }

    @Override
    public boolean isApplicableTo(IExpression expression) {
        boolean isUnfoldedQuantifier;
        boolean isSum = expression instanceof Sum;
        boolean bl = isUnfoldedQuantifier = expression instanceof IQuantifierExpression && ((IQuantifierExpression)expression).isUnfold();
        return !isSum && !isUnfoldedQuantifier;
    }
}

