/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.solver;

import com.ibm.icu.text.SimpleDateFormat;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Model;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.activation.UnsupportedDataTypeException;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.solutions.ExplorationResult;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.smt.AF3ExplorationSMTActivator;
import org.fortiss.af3.exploration.smt.modeltransformation.DSMLtoSMTTransformator;
import org.fortiss.af3.exploration.smt.solver.ContextWrapper;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.BaseMathUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public abstract class SolverRun {
    protected final ExplorationSpecification expSpec;
    private int timeout_s;
    private String solutionNamePrefix;

    public SolverRun(ExplorationSpecification expSpec, int timeout_s, String solutionNamePrefix) throws Exception {
        this.expSpec = expSpec;
        this.timeout_s = timeout_s;
        this.solutionNamePrefix = solutionNamePrefix;
        List<IExplorationConstraint<?>> basicConstraints = this.defineBasicConstraints();
        if (basicConstraints.isEmpty()) {
            throw new Exception("No basic problem description constraints for Z3 were given. Cannot perform DSE.");
        }
        this.expSpec.getTargets().addAll(0, basicConstraints);
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            System.out.println(solutionNamePrefix + "Run");
        }
    }

    public abstract List<IExplorationConstraint<?>> defineBasicConstraints() throws Exception;

    /*
     * Exception decompiling
     */
    public <T extends IModelElement> Optional<ExplorationSolution> solve(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void extractFailedConstraints(BoolExpr[] unsatCores, ExplorationSolution expSolution, Map<BoolExpr, Pair<BoolExpr, IExplorationConstraint<?>>> trackingConstraints) {
        Map<Expr, IExplorationConstraint> trackingExpressions = trackingConstraints.values().stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        EList infeasConstraints = expSolution.getUnsatConstraints();
        BoolExpr[] boolExprArray = unsatCores;
        int n = unsatCores.length;
        int n2 = 0;
        while (n2 < n) {
            BoolExpr boolExpr = boolExprArray[n2];
            IExplorationConstraint constraint = trackingExpressions.get(boolExpr);
            if (constraint != null) {
                String actionMsg;
                if (!infeasConstraints.contains(constraint)) {
                    infeasConstraints.add(constraint);
                    actionMsg = "extracted";
                } else {
                    actionMsg = "skipped (already seen)";
                }
                this.logZ3info("Unsat core " + actionMsg + " :" + String.valueOf(boolExpr) + " -> " + constraint.getName() + "\n" + String.valueOf(constraint.getExpression()) + "\n");
            } else {
                this.logZ3info("Unsat core skipped: " + String.valueOf(boolExpr) + " -> <unmatched>.");
            }
            ++n2;
        }
    }

    protected abstract <T extends IModelElement> Map<Class<T>, Collection<T>> transformSolution(DSMLtoSMTTransformator var1, Model var2) throws UnsupportedDataTypeException;

    protected abstract <T extends IModelElement> Class<T> getSolutionEntryType();

    protected abstract <T extends IModelElement> String getSolutionModelName(Class<T> var1);

    public <T extends IModelElement> void convertSolutionModels(DSMLtoSMTTransformator transformation, Model z3Model, SingleExplorationSolution singleExpSol) {
        try {
            Map<Class<T>, Collection<T>> solutions = this.transformSolution(transformation, z3Model);
            for (Map.Entry<Class<T>, Collection<T>> solEntry : solutions.entrySet()) {
                Class<T> type = solEntry.getKey();
                String name = this.getSolutionModelName(type);
                SuperSet allocSet = DSMLModelElementFactory.createSuperSet((String)name, type);
                allocSet.getEntries().addAll(solEntry.getValue());
                singleExpSol.putSolutionModel(type, allocSet);
            }
        }
        catch (UnsupportedDataTypeException e) {
            LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)("[Z3] Storing the solution failed: " + e.getMessage() + ". Skipping."), (Throwable)e);
        }
    }

    private boolean solveOptimized(int numberOfRuns, DSMLtoSMTTransformator transformator, ExplorationSolution expSolution, IProgressMonitor monitor) throws Z3Exception {
        Optimize solver = this.createZ3Optimizer(transformator);
        this.logZ3info("\n SMT Problem: \n" + solver.toString());
        Map<Expr, IExplorationObjective<?>> objectiveMapping = transformator.getObjectiveMapping();
        int i = 0;
        while (i < numberOfRuns) {
            ContextWrapper context = transformator.getContext();
            Z3CancelThread z3CancelThread = monitor != null ? new Z3CancelThread(context, monitor) : null;
            SingleExplorationSolution singleSolution = ExplorationModelElementFactory.createSingleExplorationSolution();
            singleSolution.setName(this.solutionNamePrefix + " " + i);
            this.logZ3info("Solving problem with optimizer with parameters\n" + String.valueOf(solver.getParameterDescriptions()) + "\ntimeout: " + context.getTimeoutS() + "s");
            long currentTimeMillis = System.currentTimeMillis();
            if (z3CancelThread != null) {
                z3CancelThread.start();
            }
            Status check = solver.Check(new Expr[0]);
            if (z3CancelThread != null && z3CancelThread.requestStop()) {
                return false;
            }
            long time_s = (System.currentTimeMillis() - currentTimeMillis) / 1000L;
            this.logZ3info(String.valueOf(check) + " Solved problem with optimizer with parameters " + String.valueOf(solver.getParameterDescriptions()) + " Time: " + time_s + "s");
            if (check.equals((Object)Status.UNSATISFIABLE)) {
                if (!expSolution.getSolutions().isEmpty()) {
                    if (monitor == null) break;
                    monitor.worked(numberOfRuns - i);
                    break;
                }
                expSolution.setSolutionState(SolutionState.UNSAT);
                if (monitor != null) {
                    monitor.worked(1);
                }
            } else {
                if (check.equals((Object)Status.UNKNOWN)) {
                    singleSolution.setSolutionState(SolutionState.OPTIMIZED);
                } else {
                    singleSolution.setSolutionState(SolutionState.OPTIMAL);
                }
                Model model = solver.getModel();
                this.logZ3info("\n SMT Model: \n" + String.valueOf(model));
                try {
                    this.convertSolutionModels(transformator, model, singleSolution);
                    this.convertSolutionResults(model, singleSolution, objectiveMapping);
                    expSolution.getSolutions().add((Object)singleSolution);
                }
                catch (Exception e) {
                    singleSolution.setSolutionState(SolutionState.UNKNOWN);
                    throw new Z3Exception("The back-conversation of the Z3 Model failed.", e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            ++i;
        }
        this.updateExplorationSolutionState(expSolution);
        return true;
    }

    public Optimize createZ3Optimizer(DSMLtoSMTTransformator transformator) {
        Optimize solver = Z3javaAPIWrapper.createOptimize((Context)transformator.getContext());
        for (ArithExpr a : transformator.getToMinimize()) {
            solver.MkMinimize((Expr)a);
        }
        for (ArithExpr a : transformator.getToMaximize()) {
            solver.MkMaximize((Expr)a);
        }
        Collection z3Constraints = LambdaUtils.filterByType(transformator.getConstraints(), BoolExpr.class);
        solver.Add((Expr[])z3Constraints.toArray(new BoolExpr[0]));
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            this.dumpSMTLibFile(solver.toString(), "SMT_DEBUG");
        }
        return solver;
    }

    private void updateExplorationSolutionState(ExplorationSolution expSolution) {
        EList solutions = expSolution.getSolutions();
        if (solutions.stream().anyMatch(s -> s.getSolutionState() == SolutionState.OPTIMAL)) {
            expSolution.setSolutionState(SolutionState.OPTIMAL);
            return;
        }
        if (solutions.stream().anyMatch(s -> s.getSolutionState() == SolutionState.OPTIMIZED)) {
            expSolution.setSolutionState(SolutionState.OPTIMIZED);
            return;
        }
        if (!solutions.isEmpty() && solutions.stream().allMatch(s -> s.getSolutionState() == SolutionState.UNKNOWN)) {
            expSolution.setSolutionState(SolutionState.UNKNOWN);
            return;
        }
        Assert.isTrue((expSolution.getSolutionState() == SolutionState.UNSAT ? 1 : 0) != 0);
    }

    public boolean solveNonOptimized(DSMLtoSMTTransformator transformation, ExplorationSolution expSolution, IProgressMonitor monitor) throws Z3Exception {
        Solver solver = this.createConstraintSolver(transformation);
        this.logZ3info("Parameters: " + String.valueOf(solver.getParameterDescriptions()));
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            this.dumpSMTLibFile(solver.toString(), "SMT_DEBUG");
        }
        this.logZ3info("\n SMT Problem: \n" + solver.toString());
        ContextWrapper context = transformation.getContext();
        this.logZ3info("Solving problem without optimizer with parameters\n" + String.valueOf(solver.getParameterDescriptions()) + "\ntimeout: " + context.getTimeoutS() + "s");
        long currentTimeMillis = System.currentTimeMillis();
        Z3CancelThread z3CancelThread = null;
        if (monitor != null) {
            z3CancelThread = new Z3CancelThread(context, monitor);
            z3CancelThread.start();
        }
        Status check = solver.check();
        if (z3CancelThread != null && z3CancelThread.requestStop()) {
            return false;
        }
        if (check.equals((Object)Status.SATISFIABLE)) {
            Model model = solver.getModel();
            this.logZ3info("\n SMT Model: \n" + String.valueOf(model));
            SingleExplorationSolution singleSol = ExplorationModelElementFactory.createSingleExplorationSolution();
            singleSol.setName(this.solutionNamePrefix);
            this.convertSolutionModels(transformation, model, singleSol);
            singleSol.setSolutionState(SolutionState.OPTIMAL);
            expSolution.setSolutionState(SolutionState.OPTIMAL);
            expSolution.getSolutions().add((Object)singleSol);
        } else if (check.equals((Object)Status.UNSATISFIABLE)) {
            if (context.isTrackConstraints()) {
                this.extractFailedConstraints(solver.getUnsatCore(), expSolution, transformation.getConstraintToTrack());
            }
            expSolution.setSolutionState(SolutionState.UNSAT);
        } else if (check.equals((Object)Status.UNKNOWN)) {
            if (context.isTrackConstraints()) {
                LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)("Solver returned UNKNOWN. Reason: " + solver.getReasonUnknown()));
            }
            expSolution.setSolutionState(SolutionState.UNKNOWN);
        }
        long time = (System.currentTimeMillis() - currentTimeMillis) / 1000L;
        this.logZ3info(String.valueOf(check) + " Solved problem without optimizer with parameters " + String.valueOf(solver.getParameterDescriptions()) + " Time: " + time + "s");
        return true;
    }

    public Solver createConstraintSolver(DSMLtoSMTTransformator transformator) {
        Solver solver = transformator.getContext().mkSolver();
        Collection constraints = LambdaUtils.filterByType(transformator.getConstraints(), BoolExpr.class);
        Map<BoolExpr, Pair<BoolExpr, IExplorationConstraint<?>>> trackingConstraints = transformator.getConstraintToTrack();
        ArrayList<BoolExpr> untrackedConstraints = new ArrayList<BoolExpr>();
        for (BoolExpr expr : constraints) {
            if (trackingConstraints.containsKey(expr)) {
                solver.assertAndTrack((Expr)expr, (Expr)trackingConstraints.get(expr).getLeft());
                continue;
            }
            untrackedConstraints.add(expr);
        }
        Expr[] untrackedConstraintsArrray = untrackedConstraints.toArray(new Expr[0]);
        solver.add(untrackedConstraintsArrray);
        return solver;
    }

    private void logZ3info(String msg) {
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("[Z3] " + msg));
        }
    }

    public void dumpSMTLibFile(String string, String baseName) {
        SimpleDateFormat sdfmt = new SimpleDateFormat("yyyy-MM-d-Hms");
        String filePath = FileUtils.getDefaultGeneralProjectPath() + File.separator + baseName + "_" + sdfmt.format(new Date()) + ".smt2";
        System.out.println(filePath);
        this.logZ3info("Dumping SMT script to \"" + filePath + "\".");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                writer.write(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
        }
    }

    private void convertSolutionResults(Model z3Model, SingleExplorationSolution singleSolution, Map<Expr, IExplorationObjective<?>> objectiveMapping) {
        try {
            for (Map.Entry<Expr, IExplorationObjective<?>> entry : objectiveMapping.entrySet()) {
                IExplorationObjective<?> castedObjective = entry.getValue();
                Class expectedType = entry.getValue().getResultType();
                ExplorationResult result = null;
                Expr z3EvalResult = z3Model.eval(entry.getKey(), true);
                if (z3EvalResult instanceof IntNum && BaseMathUtils.isIntegerNumber((Class)expectedType)) {
                    value = BaseMathUtils.convertNumber((Number)((IntNum)z3EvalResult).getInt(), (Class)expectedType);
                    result = ExplorationModelElementFactory.createExplorationResult((Class)expectedType, (Object)value);
                } else if (z3EvalResult instanceof IntNum && BaseMathUtils.isFloatNumber((Class)expectedType)) {
                    value = BaseMathUtils.convertNumber((Number)((IntNum)z3EvalResult).getInt(), (Class)expectedType);
                    result = ExplorationModelElementFactory.createExplorationResult((Class)expectedType, (Object)value);
                } else if (z3EvalResult instanceof RatNum && BaseMathUtils.isFloatNumber((Class)expectedType)) {
                    RatNum ratnum = (RatNum)z3EvalResult;
                    IntNum denominator = ratnum.getDenominator();
                    IntNum numerator = ratnum.getNumerator();
                    if (denominator.getInt() == 1) {
                        Number value = BaseMathUtils.convertNumber((Number)numerator.getInt(), (Class)expectedType);
                        result = ExplorationModelElementFactory.createExplorationResult((Class)expectedType, (Object)value);
                    } else {
                        LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)("Could not transform " + String.valueOf(z3EvalResult) + " into integer value. The returned value from the solver is not an integer value."));
                    }
                } else {
                    String errStr = "Could not transform " + String.valueOf(z3EvalResult) + " to the exptected type " + expectedType.getSimpleName() + ".";
                    LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)errStr);
                    throw new Z3Exception(errStr);
                }
                singleSolution.put(castedObjective, result);
            }
        }
        catch (Z3Exception e) {
            LoggingUtils.error((Plugin)AF3ExplorationSMTActivator.getDefault(), (String)e.getMessage());
            throw new Z3Exception(e.getMessage());
        }
    }

    private final class Z3CancelThread
    extends Thread {
        private static final int INTERVAL_MS = 500;
        private final Context context;
        private final IProgressMonitor monitor;
        private boolean isRunning = false;

        private Z3CancelThread(Context context, IProgressMonitor monitor) {
            Assert.isNotNull((Object)context);
            Assert.isNotNull((Object)monitor);
            this.context = context;
            this.monitor = monitor;
        }

        public boolean requestStop() {
            this.isRunning = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                LoggingUtils.warning((Plugin)AF3ExplorationActivator.getDefault(), (String)"Z3 cancellation thread has been interrupted.", (Throwable)e);
            }
            return this.monitor.isCanceled();
        }

        @Override
        public synchronized void start() {
            this.isRunning = true;
            if (!this.monitor.isCanceled()) {
                super.start();
            }
        }

        @Override
        public void run() {
            while (this.isRunning) {
                if (this.monitor.isCanceled()) {
                    this.context.interrupt();
                    LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)"Z3 has been canceled.");
                    return;
                }
                try {
                    Z3CancelThread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LoggingUtils.warning((Plugin)AF3ExplorationActivator.getDefault(), (String)"Z3 cancellation thread has been interrupted.", (Throwable)e);
                    return;
                }
            }
        }
    }
}

