/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.End;
import org.fortiss.af3.exploration.dseml.model.function.FunctionFactory;
import org.fortiss.af3.exploration.dseml.model.function.IFunction;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledSignal;
import org.fortiss.af3.exploration.dseml.model.function.ScheduledTask;
import org.fortiss.af3.exploration.dseml.model.function.Start;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.model.ExplorationObjective;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.smt.model.dseml.DsemlFactory;
import org.fortiss.af3.exploration.smt.model.dseml.FrequencyAssigned;
import org.fortiss.af3.exploration.smt.modeltransformation.EnergyConstraintDefinition;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.annotation.Frequency;
import org.fortiss.af3.platform.model.annotation.PowerConsumption;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationTrigger;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.schedule.utils.AF3ScheduleModelElementFactory;
import org.fortiss.af3.task.model.Message;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.af3.timing.model.annotation.TransmissionUnitBandwidth;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;

public class ConstraintDefinitionUtils {
    public RuleSet createLatencyMinRuleSet(SuperSet<ResourceAllocation> rsAllocs) {
        RuleSet rs = DSEProjectModelElementFactory.createRuleSet((String)"Latency Minimization Objective", (String)"None", (String)"");
        ArrayList objectives = Lists.newArrayList((Object[])new IFunction[]{EnergyConstraintDefinition.createMinimizeSumObjective(rsAllocs)});
        int i = 0;
        for (IFunction o : objectives) {
            HashSet categories = Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
            ExplorationObjective oSmt = ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)categories, (IExpression)o, (String)("Latency Minimization Objective " + i++));
            rs.getExplorationTargets().add((Object)oSmt);
        }
        return rs;
    }

    public static Equal defineStronglyCausal(Set<Task> taskSet, boolean bool) {
        ModelElementLiteral arg = DSMLModelElementFactory.createModelElementLiteral(taskSet);
        StronglyCausal sc = DSMLModelElementFactory.createStronglyCausal((ModelElementLiteral)arg);
        BooleanLiteral literal = DSMLModelElementFactory.createBooleanLiteral((boolean)bool);
        Equal strongly = DSMLModelElementFactory.createEquals((IExpression)sc, (IExpression)literal);
        return strongly;
    }

    public static Allocation defineAllocation(Set<Task> taskSet, Set<ExecutionUnit> ecuSet) {
        ModelElementLiteral task = DSMLModelElementFactory.createModelElementLiteral(taskSet);
        ModelElementLiteral ecu = DSMLModelElementFactory.createModelElementLiteral(ecuSet);
        Allocation allocation = DSMLModelElementFactory.createAllocation((ModelElementLiteral)task, (ModelElementLiteral)ecu);
        return allocation;
    }

    public static <T extends IModelElement> Start createStart(Set<?> setReference, Set<Task> taskSet) {
        Start start = FunctionFactory.eINSTANCE.createStart();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        start.setArgs(modelElementLiteral);
        start.setSetReference(taskSet.getCastedSet(IModelElement.class));
        return start;
    }

    public static <T extends IModelElement> Start createStartRoute(Set<?> setReference, Set<ExecutionUnit> ecuSet) {
        Start start = FunctionFactory.eINSTANCE.createStart();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        start.setArgs(modelElementLiteral);
        start.setSetReference(ecuSet.getCastedSet(IModelElement.class));
        return start;
    }

    public static <T extends IModelElement> End createEnd(Set<?> setReference, Set<Task> taskSet) {
        End end = FunctionFactory.eINSTANCE.createEnd();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        end.setArgs(modelElementLiteral);
        end.setSetReference(taskSet.getCastedSet(IModelElement.class));
        return end;
    }

    public static <T extends IModelElement> End createEndRoute(Set<?> setReference, Set<ExecutionUnit> ecuSet) {
        End end = FunctionFactory.eINSTANCE.createEnd();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(setReference);
        end.setArgs(modelElementLiteral);
        end.setSetReference(ecuSet.getCastedSet(IModelElement.class));
        return end;
    }

    public static ArithmeticPropertyLiteral<ExecutionUnit, Number> createPowerConsumptionLiteral(Set<ExecutionUnit> set) {
        return DSMLModelElementFactory.createAnnotationArithPropLit(set, PowerConsumption.class);
    }

    public static boolean intersects(Route route1, Route route2) {
        java.util.Set<IModelElement> route1Units = ConstraintDefinitionUtils.getTransmissionUnits(route1);
        java.util.Set<IModelElement> route2Units = ConstraintDefinitionUtils.getTransmissionUnits(route2);
        route1Units.retainAll(route2Units);
        return !route1Units.isEmpty();
    }

    private static java.util.Set<IModelElement> getTransmissionUnits(Route route) {
        return route.getAllSegments().stream().map(s -> s.getEntity()).filter(e -> e instanceof TransmissionUnit).collect(Collectors.toSet());
    }

    public static boolean isLocal(Route route) {
        Segment segment = route.getRootSegment();
        return segment.getNext().isEmpty();
    }

    public static int getMinBandwidth(Route route) {
        int minBandwidth = 0;
        for (IModelElement element : ConstraintDefinitionUtils.getTransmissionUnits(route)) {
            int capacity = (int)((TransmissionUnitBandwidth)AnnotationUtils.getAnnotation((IModelElement)element, TransmissionUnitBandwidth.class)).getBandwidth_MBitS();
            if (minBandwidth != 0 && capacity >= minBandwidth) continue;
            minBandwidth = capacity;
        }
        return minBandwidth;
    }

    public static Equal defineIsTask(Set<ResourceAllocation> setReference, boolean bool) {
        ModelElementLiteral arg = DSMLModelElementFactory.createModelElementLiteral(setReference);
        IsTask it = DSMLModelElementFactory.createIsTask((ModelElementLiteral)arg);
        BooleanLiteral literal = DSMLModelElementFactory.createBooleanLiteral((boolean)bool);
        Equal equality = DSMLModelElementFactory.createEquals((IExpression)it, (IExpression)literal);
        return equality;
    }

    public static boolean isStronglyCausal(Task task, SuperSet<ComponentToTaskAllocationEntry> ca2ta) {
        if (ca2ta == null) {
            return false;
        }
        for (ComponentToTaskAllocationEntry entry : ca2ta.getEntries()) {
            if (entry.getTask() != task) continue;
            for (IModelElement comp : entry.getSourceElements()) {
                if (!((Component)comp).isStronglyCausal()) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends IModelElement> ScheduledSignal createScheduledSignal(Set<?> sourceReference, Set<T> targetReference) {
        ScheduledSignal elem = FunctionFactory.eINSTANCE.createScheduledSignal();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(sourceReference);
        elem.setArgs(modelElementLiteral);
        elem.setSetReference(targetReference);
        return elem;
    }

    public static FrequencyAssigned createFrequencyAssigned(Set<ExecutionUnit> ecuSet) {
        FrequencyAssigned elem = DsemlFactory.eINSTANCE.createFrequencyAssigned();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(ecuSet);
        elem.setArg0(modelElementLiteral);
        return elem;
    }

    public static <T extends IModelElement> ScheduledTask createScheduledTask(Set<?> sourceReference, Set<T> targetReference) {
        ScheduledTask elem = FunctionFactory.eINSTANCE.createScheduledTask();
        ModelElementLiteral modelElementLiteral = DSMLModelElementFactory.createModelElementLiteral(sourceReference);
        elem.setArgs(modelElementLiteral);
        elem.setSetReference(targetReference);
        return elem;
    }

    public static ExecutionUnit getExecutionUnit(Task task, SuperSet<TaskToExecutionUnitAllocationEntry> ta2hw) {
        for (TaskToExecutionUnitAllocationEntry entry : ta2hw.getEntries()) {
            if (!entry.getTasks().contains((Object)task)) continue;
            return entry.getExecutionUnit();
        }
        return null;
    }

    public static List<Task> getTasks(ExecutionUnit executionUnit, SuperSet<TaskToExecutionUnitAllocationEntry> ta2hw) {
        for (TaskToExecutionUnitAllocationEntry entry : ta2hw.getEntries()) {
            if (entry.getExecutionUnit() != executionUnit) continue;
            return entry.getTasks();
        }
        return null;
    }

    public static Signal getSignal(TaskOutputPort source, TaskInputPort target, SuperSet<Signal> signalSS) {
        for (Signal signal : signalSS.getEntries()) {
            if (signal.getSourceTaskPort() != source || signal.getTargetTaskPort() != target) continue;
            return signal;
        }
        return null;
    }

    private static ResourceAllocation createResourceAllocationMessage(TaskOutputPort senderPort, TaskInputPort receiverPort) {
        Message message = TaskModelElementFactory.createMessage((TaskOutputPort)senderPort, (TaskInputPort[])new TaskInputPort[]{receiverPort});
        message.setModelElement((IModelElement)senderPort);
        String senderName = senderPort.getTask().getName();
        String receiverName = receiverPort.getTask().getName();
        message.setName("Signal_" + senderName + "_to_" + receiverName + "_" + senderPort.getName());
        ResourceAllocation resourceAllocation = AF3ScheduleModelElementFactory.createResourceAllocation((String)message.getName());
        resourceAllocation.setDuration(new BigDecimal(5));
        resourceAllocation.setSchedulableEntity((SchedulableEntity)message);
        PeriodicTimeTrigger trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        resourceAllocation.setTrigger((ResourceAllocationTrigger)trigger);
        return resourceAllocation;
    }

    public static Set<Signal> createSignalSetFromMessage(SuperSet<Signal> signalSS, Message message) {
        IModelElement modelElement = message.getModelElement();
        Signal signal = ConstraintDefinitionUtils.getSignal((TaskOutputPort)modelElement, (TaskInputPort)message.getReceivers().get(0), signalSS);
        Set signalSet = DSMLModelElementFactory.createSet(signalSS, (IModelElement)signal, (String)"aSignalSet", Signal.class);
        return signalSet;
    }

    public static List<ResourceAllocation> getFilteredResourceAllocations(EList<ResourceAllocation> raList, ExecutionUnit resource) {
        ArrayList<ResourceAllocation> list = new ArrayList<ResourceAllocation>();
        for (ResourceAllocation ra : raList) {
            if (ra.getPhysicalResource() != resource) continue;
            list.add(ra);
        }
        return list;
    }

    public static List<Long> getAdmissibleFrequencies(ExecutionUnit ecu) {
        ArrayList<Long> admissibleFreq = new ArrayList<Long>();
        if (!AnnotationUtils.hasAnnotation((IModelElement)ecu, Frequency.class)) {
            admissibleFreq.add(500L);
        } else {
            Frequency freq = (Frequency)AnnotationUtils.getAnnotation((IModelElement)ecu, Frequency.class);
            admissibleFreq.addAll((Collection<Long>)freq.getFrequenciesHz());
            if (admissibleFreq.isEmpty()) {
                admissibleFreq.add(500L);
            }
        }
        return admissibleFreq;
    }
}

