/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.smt.util;

import com.microsoft.z3.Context;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.math.BigDecimal;
import java.text.Normalizer;
import org.fortiss.af3.exploration.dseml.model.expression.IPropertyLiteral;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;

public class SMTTransformationUtils {
    public static String getFunctionName(IPropertyLiteral<? extends IModelElement, ? extends Number> propLit) {
        return SMTTransformationUtils.getFunctionName(propLit.getName());
    }

    public static String getFunctionName(String propLitName) {
        return "f_" + propLitName + "_value";
    }

    public static Symbol createSymbol(Context context, IModelElement modelElement) {
        String name = SMTTransformationUtils.createUniqueASCIIModelName(modelElement);
        return Z3javaAPIWrapper.createSymbol((Context)context, (String)name);
    }

    public static String createUniqueASCIIModelName(IModelElement modelElement) {
        Object modelName = modelElement.toString();
        if (modelElement instanceof INamedElement) {
            INamedElement namedME = (INamedElement)modelElement;
            modelName = namedME.getName();
            modelName = (String)modelName + "_" + namedME.getId();
        }
        modelName = Normalizer.normalize((CharSequence)modelName, Normalizer.Form.NFD);
        Object modelNameASCII = ((String)modelName).replaceAll("[^\\x00-\\x7F]", "_");
        String typeName = modelElement.getClass().getSimpleName();
        if (typeName.length() > 1) {
            char charAt = typeName.charAt(0);
            String substring = typeName.substring(0, 2).toLowerCase();
            String prefix = "";
            if (Character.isDigit(charAt)) {
                prefix = "x";
            }
            modelNameASCII = prefix + substring + "_" + (String)modelNameASCII;
        } else {
            modelNameASCII = "xx_" + (String)modelName;
        }
        modelNameASCII = ((String)modelNameASCII).replace(" ", "_");
        modelNameASCII = ((String)modelNameASCII).replace(":", "");
        modelNameASCII = ((String)modelNameASCII).replace(";", "");
        modelNameASCII = ((String)modelNameASCII).replace(".", "");
        modelNameASCII = ((String)modelNameASCII).replace("@", "");
        modelNameASCII = ((String)modelNameASCII).replace("(", "");
        modelNameASCII = ((String)modelNameASCII).replace(")", "");
        return modelNameASCII;
    }

    public static BigDecimal toDecimal(RatNum rationalNumber) {
        double numerator = rationalNumber.getBigIntNumerator().doubleValue();
        double denominator = rationalNumber.getBigIntDenominator().doubleValue();
        return new BigDecimal(numerator / denominator);
    }
}

