/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.base;

import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;

@RunWith(value=Parameterized.class)
public abstract class SMTTestBase {
    protected String testProject;
    protected TestProcedure testProcedure;
    protected DSE dse;
    protected ExplorationSpecification expSpec;

    public SMTTestBase(String testProject, TestProcedure testProcedure) {
        this.testProject = testProject;
        this.testProcedure = testProcedure;
    }

    @Before
    public void setUp() {
        this.dse = TestDSEUtils.initializeDSE(TestDSEUtils.loadTestProject(this.testProject));
        this.expSpec = ExplorationModelElementFactory.createExplorationSpecification();
        this.expSpec.setSearchSpace(this.dse.getCurrentStep().getSuperSetMap());
    }

    @Test
    public void test() throws Exception {
        this.testProcedure.initialize(this.dse, this.expSpec);
        this.testProcedure.execute();
    }
}

