/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.base;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.junit.Assert;

public abstract class TestProcedure {
    protected int SMT_TIMEOUT_MS = 10000;
    protected String testProject;
    ITopLevelElement modelCtx;
    protected DSE dse;
    protected ExplorationSpecification expSpec;

    public void initialize(DSE dse, ExplorationSpecification expSpec) {
        this.dse = dse;
        this.modelCtx = IPersistencyService.getInstance().getTopLevelElementFor((EObject)dse);
        this.expSpec = expSpec;
    }

    public void execute() throws Exception {
        this.modelCtx.runAsCommand(() -> this.modifyModel());
        this.expSpec.getTargets().addAll(ExplorationUtils.convertRuleSetsToExplorationSpec((Collection)EcoreUtils.pickInstanceOf(RuleSet.class, (List)this.dse.getCurrentStep().getSystemConstraintSets()), this.getSynthCategories()));
        this.expSpec.getTargets().addAll(this.createAdditionalConstraints());
        SolverRun solver = this.getSolverRun();
        Optional<ExplorationSolution> solution = solver.solve((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)solution.isPresent());
        this.assertResults(solution.get());
    }

    protected void modifyModel() {
    }

    protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
        return Collections.emptyList();
    }

    protected abstract SolverRun getSolverRun() throws Exception;

    protected abstract Collection<Class<? extends ISynthesisCategory>> getSynthCategories();

    public abstract void assertResults(ExplorationSolution var1);
}

