/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.constraints;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.suite.base.UnsatisfiableTestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;

public class FunctionCouplingTest
extends SMTTestBase {
    public FunctionCouplingTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        return Arrays.asList({"system_test_flat", new TestCouplingSat()}, {"system_test_flat", new TestCouplingUnsat()}, {"system_test_flat", new TestDecouplingSat()}, {"system_test_flat", new TestDecouplingUnsat()});
    }

    private static class TestCouplingSat
    extends TestProcedure {
        private TestCouplingSat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            IExpression coupling = PatternFactoryUtils.createFunctionCouplingPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[0], tasks[1]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)coupling, (String)"Function Coupling: ECU 0 : ECU 1", (boolean)false));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertEquals((Object)TestDeploymentUtils.getExecutionUnitFromAllocation(solution, tasks[0]), (Object)TestDeploymentUtils.getExecutionUnitFromAllocation(solution, tasks[1]));
        }
    }

    private static class TestCouplingUnsat
    extends UnsatisfiableTestProcedure {
        private TestCouplingUnsat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression allocate0 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[0]), Arrays.asList(executionUnits[1]));
            IBooleanExpression allocate1 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[1]), Arrays.asList(executionUnits[0]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)allocate0, (String)"Allocation: Task 0 - ECU 1", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)allocate1, (String)"Allocation: Task 1 - ECU 0", (boolean)false));
            IExpression coupling = PatternFactoryUtils.createFunctionCouplingPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[0], tasks[1]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)coupling, (String)"Function Coupling: ECU 0 : ECU 1", (boolean)false));
            return explorationTargets;
        }
    }

    private static class TestDecouplingSat
    extends TestProcedure {
        private TestDecouplingSat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            IExpression coupling = PatternFactoryUtils.createFunctionCouplingPatternExpression((DSE)this.dse, (boolean)false, Arrays.asList(tasks[0], tasks[1]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)coupling, (String)"Function Decoupling: ECU 0 : ECU 1", (boolean)false));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertNotEquals((Object)TestDeploymentUtils.getExecutionUnitFromAllocation(solution, tasks[0]), (Object)TestDeploymentUtils.getExecutionUnitFromAllocation(solution, tasks[1]));
        }
    }

    private static class TestDecouplingUnsat
    extends UnsatisfiableTestProcedure {
        private TestDecouplingUnsat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression allocate0 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[0]), Arrays.asList(executionUnits[0]));
            IBooleanExpression allocate1 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[1]), Arrays.asList(executionUnits[0]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)allocate0, (String)"Allocation: Task 0 - ECU 1", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)allocate1, (String)"Allocation: Task 1 - ECU 0", (boolean)false));
            IExpression coupling = PatternFactoryUtils.createFunctionCouplingPatternExpression((DSE)this.dse, (boolean)false, Arrays.asList(tasks[0], tasks[1]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)coupling, (String)"Function Decoupling: ECU 0 : ECU 1", (boolean)false));
            return explorationTargets;
        }
    }
}

