/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.constraints;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.annotation.RamRequirement;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.suite.base.UnsatisfiableTestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;

public class MemoryTest
extends SMTTestBase {
    public MemoryTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        return Arrays.asList({"system_test_flat", new TestMemorySat()}, {"system_test_flat", new TestMemoryUnsat()});
    }

    private static class TestMemorySat
    extends TestProcedure {
        private TestMemorySat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression memory0 = PatternFactoryUtils.createUtilizationPatternExpression((DSE)this.dse, (double)1.0, (ExecutionUnit)executionUnits[0], RamRequirement.class, RamSize.class);
            IBooleanExpression memory1 = PatternFactoryUtils.createUtilizationPatternExpression((DSE)this.dse, (double)1.0, (ExecutionUnit)executionUnits[1], RamRequirement.class, RamSize.class);
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)memory0, (String)"Memory: ECU 0 - 100%", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)memory1, (String)"Memory: ECU 1 - 100%", (boolean)false));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            HashMap<Task, ExecutionUnit> expectedDeployment = new HashMap<Task, ExecutionUnit>();
            expectedDeployment.put(tasks[0], executionUnits[0]);
            expectedDeployment.put(tasks[1], executionUnits[1]);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertTrue((boolean)TestDeploymentUtils.matchesDeployment(expectedDeployment, solution));
        }
    }

    private static class TestMemoryUnsat
    extends UnsatisfiableTestProcedure {
        private TestMemoryUnsat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression memory0 = PatternFactoryUtils.createUtilizationPatternExpression((DSE)this.dse, (double)0.5, (ExecutionUnit)executionUnits[0], RamRequirement.class, RamSize.class);
            IBooleanExpression memory1 = PatternFactoryUtils.createUtilizationPatternExpression((DSE)this.dse, (double)0.5, (ExecutionUnit)executionUnits[1], RamRequirement.class, RamSize.class);
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)memory0, (String)"Memory: ECU 0 - 50%", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)memory1, (String)"Memory: ECU 1 - 50%", (boolean)false));
            return explorationTargets;
        }
    }
}

