/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.constraints;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.safety.model.SIL;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.suite.base.UnsatisfiableTestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;

public class SafetyTest
extends SMTTestBase {
    public SafetyTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        return Arrays.asList({"system_test_flat", new TestSafetySat()}, {"system_test_flat", new TestSafetyUnsat()});
    }

    private static class TestSafetySat
    extends TestProcedure {
        private TestSafetySat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        public void modifyModel() {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Component[] components = (Component[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Component.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            ((SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)components[1], SafetyIntegrityLevel.class)).setSilValue(SIL.SIL1);
            ((SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)components[2], SafetyIntegrityLevel.class)).setSilValue(SIL.SIL3);
            ((SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)executionUnits[0], SafetyIntegrityLevel.class)).setSilValue(SIL.SIL0);
            ((SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)executionUnits[1], SafetyIntegrityLevel.class)).setSilValue(SIL.SIL4);
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression safety0 = PatternFactoryUtils.createSafetyPatternExpression((DSE)this.dse, (ExecutionUnit)executionUnits[0], (SuperSet)superSetMap.get(ComponentToTaskAllocationEntry.class));
            IBooleanExpression safety1 = PatternFactoryUtils.createSafetyPatternExpression((DSE)this.dse, (ExecutionUnit)executionUnits[1], (SuperSet)superSetMap.get(ComponentToTaskAllocationEntry.class));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)safety0, (String)"Safety: ECU 0", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)safety1, (String)"Safety: ECU 1", (boolean)false));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Component[] components = (Component[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Component.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            ComponentToTaskAllocationEntry[] allocationEntries = (ComponentToTaskAllocationEntry[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ComponentToTaskAllocationEntry.class);
            AllocationTableCollection allocationTableCollection = allocationEntries[0].getAllocationTable().getAllocationTableCollection();
            HashMap<Task, ExecutionUnit> expectedDeployment = new HashMap<Task, ExecutionUnit>();
            expectedDeployment.put(TestDSEUtils.getTaskFromComponent(allocationTableCollection, components[1]), executionUnits[1]);
            expectedDeployment.put(TestDSEUtils.getTaskFromComponent(allocationTableCollection, components[2]), executionUnits[1]);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertTrue((boolean)TestDeploymentUtils.matchesDeployment(expectedDeployment, solution));
        }
    }

    public static class TestSafetyUnsat
    extends UnsatisfiableTestProcedure {
        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            IBooleanExpression safety0 = PatternFactoryUtils.createSafetyPatternExpression((DSE)this.dse, (ExecutionUnit)executionUnits[0], (SuperSet)superSetMap.get(ComponentToTaskAllocationEntry.class));
            IBooleanExpression safety1 = PatternFactoryUtils.createSafetyPatternExpression((DSE)this.dse, (ExecutionUnit)executionUnits[1], (SuperSet)superSetMap.get(ComponentToTaskAllocationEntry.class));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)safety0, (String)"Safety: ECU 0", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)safety1, (String)"Safety: ECU 1", (boolean)false));
            return explorationTargets;
        }
    }
}

