/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.constraints;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.ScheduleRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.suite.base.UnsatisfiableTestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;
import test.org.fortiss.af3.exploration.smt.util.TestSchedulingUtils;

public class SchedulingTest
extends SMTTestBase {
    public SchedulingTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        return Arrays.asList({"system_test_flat", new TestDurationUnsat()}, {"system_test_flat", new TestDurationSat()}, {"system_test_flat", new TestNonOverlappingUnsat()}, {"system_test_flat", new TestNonOverlappingSat()});
    }

    public static class TestCausalitySat
    extends TestProcedure {
        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertTrue((TestSchedulingUtils.getEndTime(solution, tasks[0]) <= TestSchedulingUtils.getStartTime(solution, tasks[1]) ? 1 : 0) != 0);
        }
    }

    public static class TestCausalityUnsat
    extends UnsatisfiableTestProcedure {
        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            explorationTargets.add((IExplorationTarget<?>)TestSchedulingUtils.createPrecendenceConstraint(superSetMap, tasks[1], tasks[0]));
            return explorationTargets;
        }
    }

    private static class TestDurationSat
    extends TestProcedure {
        private TestDurationSat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected void modifyModel() {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            TaskWcetTable taskWcetTable = ((TaskWcetTable[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, TaskWcetTable.class))[0];
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[0]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(5L)));
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[1]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(10L)));
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertEquals((long)5L, (long)TestSchedulingUtils.getDuration(solution, tasks[0]));
            Assert.assertEquals((long)10L, (long)TestSchedulingUtils.getDuration(solution, tasks[1]));
        }
    }

    private static class TestDurationUnsat
    extends UnsatisfiableTestProcedure {
        private TestDurationUnsat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected void modifyModel() {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            TaskWcetTable taskWcetTable = ((TaskWcetTable[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, TaskWcetTable.class))[0];
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[0]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(50L)));
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[1]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(100L)));
        }
    }

    private static class TestNonOverlappingSat
    extends TestProcedure {
        private TestNonOverlappingSat() {
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected void modifyModel() {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            EList allocationEntries = superSetMap.get(TaskToExecutionUnitAllocationEntry.class).getEntries();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            allocationEntries.forEach(entry -> TestDeploymentUtils.modifyAllocation(entry, (IModelElement)executionUnits[0]));
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertTrue((TestSchedulingUtils.getEndTime(solution, tasks[0]) <= TestSchedulingUtils.getStartTime(solution, tasks[1]) || TestSchedulingUtils.getEndTime(solution, tasks[1]) <= TestSchedulingUtils.getStartTime(solution, tasks[0]) ? 1 : 0) != 0);
        }
    }

    public static class TestNonOverlappingUnsat
    extends UnsatisfiableTestProcedure {
        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected void modifyModel() {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            TaskWcetTable taskWcetTable = ((TaskWcetTable[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, TaskWcetTable.class))[0];
            EList allocationEntries = superSetMap.get(TaskToExecutionUnitAllocationEntry.class).getEntries();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            allocationEntries.forEach(entry -> TestDeploymentUtils.modifyAllocation(entry, (IModelElement)executionUnits[0]));
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[0]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(50L)));
            LambdaUtils.filter((Collection)taskWcetTable.getAllocationEntries(), entry -> ((TaskWcetEntry)entry).getSourceElement() == tasks[1]).forEach(entry -> ((Wcet)AnnotationUtils.getAnnotation((IModelElement)entry, Wcet.class)).setValue(BigDecimal.valueOf(100L)));
        }
    }
}

