/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.objectives;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;

public class BusBandwidthOptimizationTest
extends SMTTestBase {
    public BusBandwidthOptimizationTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        String testProject = "system_test_flat";
        Collection<TransmissionUnit> transmissionUnits = TestDSEUtils.extractTestModelElements(testProject, TransmissionUnit.class);
        return transmissionUnits.stream().map(transmissionUnit -> new Object[]{testProject, new TestMinimization(transmissionUnit.getName())}).collect(Collectors.toSet());
    }

    public static class TestMinimization
    extends TestProcedure {
        private String transmissionUnitName;

        public TestMinimization(String transmissionUnit) {
            this.transmissionUnitName = transmissionUnit;
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        }

        @Override
        public Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            TransmissionUnit testTransmissionUnit = superSetMap.get(TransmissionUnit.class).getEntries().stream().filter(t -> t.getName().equals(this.transmissionUnitName)).findAny().get();
            HashSet categories = Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
            IBooleanExpression allocate0 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[0]), Arrays.asList(executionUnits[0]));
            IBooleanExpression allocate1 = PatternFactoryUtils.createAllocationPatternExpression((DSE)this.dse, (boolean)true, Arrays.asList(tasks[1]), Arrays.asList(executionUnits[1]));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)allocate0, (String)"Allocation: Task 0 - ECU 0", (boolean)false));
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)allocate1, (String)"Allocation: Task 1 - ECU 1", (boolean)false));
            IExpression routeWeightExpression = PatternFactoryUtils.createRouteWeightConstraintPatternExpression((DSE)this.dse);
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)routeWeightExpression, (String)"BandwidthWeight", (boolean)false));
            for (TransmissionUnit bus : this.dse.getCurrentStep().getSuperSetMap().get(TransmissionUnit.class).getEntries()) {
                for (Route route : this.dse.getCurrentStep().getSuperSetMap().get(Route.class).getEntries()) {
                    IBooleanExpression routeUsesBusExpression = PatternFactoryUtils.createRouteUsesBusConstraintPatternExpression((DSE)this.dse, (TransmissionUnit)bus, (Route)route);
                    explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)routeUsesBusExpression, (String)"RouteUsesBus", (boolean)false));
                }
            }
            IExpression bandwidthOptimization = PatternFactoryUtils.createBusWeightOptimizationPatternExpression((DSE)this.dse, (TransmissionUnit)testTransmissionUnit, (boolean)true);
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)bandwidthOptimization, (String)("Bandwidth Optimization: " + this.transmissionUnitName)));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Signal[] signals = (Signal[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Signal.class);
            TransmissionUnit testTransmissionUnit = superSetMap.get(TransmissionUnit.class).getEntries().stream().filter(t -> t.getName().equals(this.transmissionUnitName)).findAny().get();
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Signal[] signalArray = signals;
            int n = signals.length;
            int n2 = 0;
            while (n2 < n) {
                Signal signal = signalArray[n2];
                Assert.assertFalse((boolean)TestDeploymentUtils.getTransmissionUnitsFromAllocation(solution, signal).contains(testTransmissionUnit));
                ++n2;
            }
        }
    }
}

