/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.objectives;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.modeltransformation.EnergyConstraintDefinition;
import org.fortiss.af3.exploration.smt.solver.ScheduleRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.Task;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestSchedulingUtils;

public class EnergyOptimizationTest
extends SMTTestBase {
    public EnergyOptimizationTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        return Arrays.asList(new Object[][]{{"system_test_hierarchical", new TestMinimization()}});
    }

    public static class TestMinimization
    extends TestProcedure {
        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new ScheduleRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Minimize minConFunc = EnergyConstraintDefinition.createMinimizeConsumptionObjective((SuperSet<ResourceAllocation>)superSetMap.get(ResourceAllocation.class), (SuperSet<Task>)superSetMap.get(Task.class), (SuperSet<ExecutionUnit>)superSetMap.get(ExecutionUnit.class));
            HashSet categories = Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createEnergyDimension(), (Collection)categories, (IExpression)minConFunc, (String)"Energy optimization objective"));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            ExecutionUnit[] executionUnits = (ExecutionUnit[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, ExecutionUnit.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Assert.assertEquals((long)500L, (long)TestSchedulingUtils.getFrequency(solution, executionUnits[0]));
            Assert.assertEquals((long)500L, (long)TestSchedulingUtils.getFrequency(solution, executionUnits[1]));
        }
    }
}

