/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.suite.objectives;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.smt.solver.SolverRun;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.af3.task.model.Task;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import test.org.fortiss.af3.exploration.smt.suite.base.SMTTestBase;
import test.org.fortiss.af3.exploration.smt.suite.base.TestProcedure;
import test.org.fortiss.af3.exploration.smt.util.TestDSEUtils;
import test.org.fortiss.af3.exploration.smt.util.TestDeploymentUtils;

public class HardwareOptimizationTest
extends SMTTestBase {
    public HardwareOptimizationTest(String testProject, TestProcedure testProcedure) {
        super(testProject, testProcedure);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testProjects() {
        String testProject = "system_test_flat";
        Collection<ExecutionUnit> executionUnits = TestDSEUtils.extractTestModelElements(testProject, ExecutionUnit.class);
        Collection testInput = executionUnits.stream().map(executionUnit -> new Object[]{testProject, new TestRamMinimization(executionUnit.getName())}).collect(Collectors.toSet());
        return testInput;
    }

    public static class TestRamMinimization
    extends TestProcedure {
        private String executionUnitName;

        public TestRamMinimization(String executionUnit) {
            this.executionUnitName = executionUnit;
        }

        @Override
        protected SolverRun getSolverRun() throws Exception {
            return new DeploymentRun(this.expSpec, this.SMT_TIMEOUT_MS);
        }

        @Override
        protected Collection<Class<? extends ISynthesisCategory>> getSynthCategories() {
            return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        }

        @Override
        protected Collection<IExplorationTarget<?>> createAdditionalConstraints() throws Exception {
            ArrayList explorationTargets = new ArrayList();
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            ExecutionUnit testExecutionUnit = superSetMap.get(ExecutionUnit.class).getEntries().stream().filter(e -> e.getName().equals(this.executionUnitName)).findAny().get();
            IExpression ramMinimization = PatternFactoryUtils.createHardwareOptimizationPatternExpression((DSE)this.dse, (boolean)true, (int)0, Arrays.asList(tasks), Arrays.asList(testExecutionUnit), RamSize.class);
            HashSet categories = Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
            explorationTargets.add((IExplorationTarget<?>)ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)ramMinimization, (String)("RAM Minimization: " + this.executionUnitName)));
            return explorationTargets;
        }

        @Override
        public void assertResults(ExplorationSolution solution) {
            SuperSetMap superSetMap = this.expSpec.getSearchSpace();
            Task[] tasks = (Task[])TestDSEUtils.getSuperSetEntries((SuperSetMap)superSetMap, Task.class);
            Assert.assertEquals((Object)SolutionState.OPTIMAL, (Object)solution.getSolutionState());
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                Assert.assertNotEquals((Object)TestDeploymentUtils.getExecutionUnitFromAllocation(solution, task).getName(), (Object)this.executionUnitName);
                ++n2;
            }
        }
    }
}

