/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.smt.AF3ExplorationSMTActivator;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.utils.TestCaseProjectUtils;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class TestDSEUtils {
    public static <T extends IModelElement> T[] getSuperSetEntries(SuperSetMap superSetMap, Class<T> type) {
        return (IModelElement[])CollectionUtils.toArray((Collection)superSetMap.get(type).getEntries(), type);
    }

    public static DSE initializeDSE(FileProject project) {
        DSE dse = DSEProjectModelElementFactory.createDSE((String)"DSE", (FileProject)project);
        KernelModelElementUtils.runAsCommand((EObject)project, () -> {
            ModelSnapshot caSnap = ModelSnapshotExtractUtils.createComponentArchitectureSnapshot((ComponentArchitecture)((ComponentArchitecture)EcoreUtils.getFirstChildWithType((EObject)project, ComponentArchitecture.class)));
            dse.getInitialStep().addSnapshot(caSnap);
            ModelSnapshot taSnap = ModelSnapshotExtractUtils.createTaskArchitectureSnapshot((TaskArchitecture)((TaskArchitecture)EcoreUtils.getFirstChildWithType((EObject)project, TaskArchitecture.class)));
            dse.getInitialStep().addSnapshot(taSnap);
            ModelSnapshot paSnap = ModelSnapshotExtractUtils.createPlatformArchitectureSnapshot((PlatformArchitecture)((PlatformArchitecture)EcoreUtils.getFirstChildWithType((EObject)project, PlatformArchitecture.class)));
            dse.getInitialStep().addSnapshot(paSnap);
            ModelSnapshot allocSnap = ModelSnapshotExtractUtils.createAllocationTableCollectionSnapshot((AllocationTableCollection)((AllocationTableCollection)EcoreUtils.getFirstChildWithType((EObject)project, AllocationTableCollection.class)), Arrays.asList(ComponentToTaskAllocationEntry.class, TaskToExecutionUnitAllocationEntry.class), Arrays.asList(caSnap, taSnap, paSnap));
            dse.getInitialStep().addSnapshot(allocSnap);
            dse.getInitialStep().addSnapshot(ModelSnapshotExtractUtils.createTimingSpecificationSnapshot(Optional.of(allocSnap.getSuperSet(TaskToExecutionUnitAllocationEntry.class)), (SuperSet)taSnap.getSuperSet(Task.class), (SuperSet)paSnap.getSuperSet(Route.class), Optional.empty(), (TimingSpecification)((TimingSpecification)EcoreUtils.getFirstChildWithType((EObject)project, TimingSpecification.class))));
            project.getRootElements().add((Object)dse);
        });
        TestDSEUtils.createRoutes(dse);
        return dse;
    }

    public static void createRoutes(DSE dse) {
        FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType((EObject)dse, FileProject.class);
        PlatformArchitecture platformArchitecture = (PlatformArchitecture)EcoreUtils.getFirstChildWithType((EObject)fileProject, PlatformArchitecture.class);
        if (platformArchitecture.getRoutes().isEmpty()) {
            SuperSetMap superSetMap = dse.getInitialStep().getSuperSetMap();
            KernelModelElementUtils.runAsCommand((EObject)fileProject, () -> {
                EList routes = platformArchitecture.getRoutes();
                EList executionUnits = superSetMap.get(ExecutionUnit.class).getEntries();
                EList transmissionUnits = superSetMap.get(TransmissionUnit.class).getEntries();
                EList gatewayUnits = superSetMap.get(GatewayUnit.class).getEntries();
                routes.addAll(RouteUtils.extractRoutes((Collection)executionUnits, (Collection)transmissionUnits, (Collection)gatewayUnits));
                UniqueIDUtils.fixMissingIDs((EObject)platformArchitecture, (EObject)fileProject);
            });
        }
    }

    public static <T extends IModelElement> Collection<T> extractTestModelElements(String testProject, Class<T> type) {
        DSE dse = TestDSEUtils.initializeDSE(TestDSEUtils.loadTestProject(testProject));
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        return superSetMap.get(type).getEntries();
    }

    public static FileProject loadTestProject(String name) {
        String extension = ".af3_23";
        String path = "test-data/" + name + (name.endsWith(extension) ? "" : extension);
        return TestCaseProjectUtils.loadTestProject((String)AF3ExplorationSMTActivator.PLUGIN_ID, (String)path);
    }

    public static Task getTaskFromComponent(AllocationTableCollection allocationTableCollection, Component component) {
        return (Task)LambdaUtils.getFirst((Collection)AllocationUtils.getAllocationTargetsTransitive((AllocationTableCollection)allocationTableCollection, (IModelElement)component, Task.class)).get();
    }
}

