/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class TestDeploymentUtils {
    public static boolean matchesDeployment(Map<Task, ExecutionUnit> expectedDeployment, ExplorationSolution explorationSolution) {
        boolean match = true;
        for (Map.Entry<Task, ExecutionUnit> entry : expectedDeployment.entrySet()) {
            ExecutionUnit actual;
            ExecutionUnit expected = entry.getValue();
            if (expected == (actual = TestDeploymentUtils.getExecutionUnitFromAllocation(explorationSolution, entry.getKey()))) continue;
            match = false;
        }
        return match;
    }

    public static ExecutionUnit getExecutionUnitFromAllocation(ExplorationSolution explorationSolution, Task task) {
        SingleExplorationSolution singleExplorationSolution = (SingleExplorationSolution)LambdaUtils.getFirst((Collection)explorationSolution.getSolutions()).get();
        EList actualDeployment = singleExplorationSolution.getSolutionModel(TaskToExecutionUnitAllocationEntry.class).getEntries();
        return ((TaskToExecutionUnitAllocationEntry)EcoreUtils.pickFirstInstanceOf(allocation -> allocation.getTasks().contains((Object)task), (List)actualDeployment)).getExecutionUnit();
    }

    public static Collection<TransmissionUnit> getTransmissionUnitsFromAllocation(ExplorationSolution explorationSolution, Signal signal) {
        SingleExplorationSolution singleExplorationSolution = (SingleExplorationSolution)LambdaUtils.getFirst((Collection)explorationSolution.getSolutions()).get();
        EList actualDeployment = singleExplorationSolution.getSolutionModel(SignalToRouteAllocationEntry.class).getEntries();
        Route route = ((SignalToRouteAllocationEntry)EcoreUtils.pickFirstInstanceOf(allocation -> allocation.getSignals().contains((Object)signal), (List)actualDeployment)).getRoute();
        return route.getAllSegments().stream().filter(segment -> segment.getEntity() instanceof TransmissionUnit).map(segment -> (TransmissionUnit)segment.getEntity()).collect(Collectors.toSet());
    }

    public static void modifyAllocation(TaskToExecutionUnitAllocationEntry entry, IModelElement target) {
        KernelModelElementUtils.runAsCommand((EObject)entry, () -> entry.setTargetElement(target));
    }
}

