/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.exploration.smt.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.timing.model.annotation.AF3TimingAnnotationFactory;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TestSchedulingUtils {
    public static Wcet createWcet(int value) {
        Wcet annotation = AF3TimingAnnotationFactory.eINSTANCE.createWcet();
        annotation.setValue(new BigDecimal(value));
        return annotation;
    }

    public static ResourceSchedule getResourceSchedule(ExplorationSolution solution, ExecutionUnit executionUnit) {
        SingleExplorationSolution singleExplorationSolution = (SingleExplorationSolution)LambdaUtils.getFirst((Collection)solution.getSolutions()).get();
        EList resourceSchedules = singleExplorationSolution.getSolutionModel(ResourceSchedule.class).getEntries();
        return (ResourceSchedule)EcoreUtils.pickFirstInstanceOf(resourceSchedule -> resourceSchedule.getResource() == executionUnit, (List)resourceSchedules);
    }

    public static long getFrequency(ExplorationSolution solution, ExecutionUnit executionUnit) {
        return TestSchedulingUtils.getResourceSchedule(solution, executionUnit).getFrequency();
    }

    public static ResourceAllocation getResourceAllocation(List<ResourceAllocation> resourceAllocations, Task task) {
        return (ResourceAllocation)EcoreUtils.pickFirstInstanceOf(resourceAllocation -> resourceAllocation.getSchedulableEntity().getModelElement() == task, resourceAllocations);
    }

    public static ResourceAllocation getResourceAllocation(ExplorationSolution solution, Task task) {
        SingleExplorationSolution singleExplorationSolution = (SingleExplorationSolution)LambdaUtils.getFirst((Collection)solution.getSolutions()).get();
        EList resourceAllocations = singleExplorationSolution.getSolutionModel(ResourceAllocation.class).getEntries();
        return TestSchedulingUtils.getResourceAllocation((List<ResourceAllocation>)resourceAllocations, task);
    }

    public static int getStartTime(ExplorationSolution solution, Task task) {
        ResourceAllocation resourceAllocation = TestSchedulingUtils.getResourceAllocation(solution, task);
        PeriodicTimeTrigger trigger = (PeriodicTimeTrigger)resourceAllocation.getTrigger();
        return trigger.getStartTime().intValue();
    }

    public static int getDuration(ExplorationSolution solution, Task task) {
        return TestSchedulingUtils.getResourceAllocation(solution, task).getDuration().intValue();
    }

    public static int getEndTime(ExplorationSolution solution, Task task) {
        int startTime = TestSchedulingUtils.getStartTime(solution, task);
        int duration = TestSchedulingUtils.getDuration(solution, task);
        return startTime + duration;
    }

    public static IExplorationConstraint<Boolean> createPrecendenceConstraint(SuperSetMap superSetMap, Task first, Task second) {
        ResourceAllocation firstAllocation = TestSchedulingUtils.getResourceAllocation((List<ResourceAllocation>)superSetMap.get(ResourceAllocation.class).getEntries(), first);
        ResourceAllocation secondAllocation = TestSchedulingUtils.getResourceAllocation((List<ResourceAllocation>)superSetMap.get(ResourceAllocation.class).getEntries(), second);
        Set secondSet = DSMLModelElementFactory.createSet((SuperSet)superSetMap.get(ResourceAllocation.class), (IModelElement)secondAllocation, ResourceAllocation.class);
        Set firstSet = DSMLModelElementFactory.createSet((SuperSet)superSetMap.get(ResourceAllocation.class), (IModelElement)firstAllocation, ResourceAllocation.class);
        ArithmeticPropertyLiteral firstStart = ExplorationTimingConstraintUtils.createStartTimeLiteral((Set)firstSet);
        ArithmeticPropertyLiteral firstDuration = ExplorationTimingConstraintUtils.createDurationLiteral((Set)firstSet);
        Plus firstEnd = DSMLModelElementFactory.createPlus((IArithmeticExpression)firstStart, (IArithmeticExpression)firstDuration);
        ArithmeticPropertyLiteral secondStart = ExplorationTimingConstraintUtils.createDurationLiteral((Set)secondSet);
        LessEqual lessEqual = DSMLModelElementFactory.createLessEqual((IArithmeticExpression)firstEnd, (IArithmeticExpression)secondStart);
        ForAll secondForAll = DSMLModelElementFactory.createForAll((Set)secondSet.getCastedSet(IModelElement.class), (IBooleanExpression)lessEqual, (boolean)true);
        ForAll firstForAll = DSMLModelElementFactory.createForAll((Set)firstSet.getCastedSet(IModelElement.class), (IBooleanExpression)secondForAll, (boolean)true);
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createTemporalDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)firstForAll, (String)"Precendence constraint", (boolean)false);
    }
}

