/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.fortiss.af3.exploration.ui.cli.CommandLineDSEPerspective;
import org.fortiss.af3.exploration.ui.cli.CommandLineDSEProjectLoading;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.service.ICommandLineInterfaceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AF3ExplorationUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = AF3ExplorationUIActivator.class.getPackage().getName();
    private static AF3ExplorationUIActivator plugin;

    public static void registerPerspectiveListener() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                AF3ExplorationUIActivator.closeOpenedViews(PlatformUI.getWorkbench());
            }
        });
    }

    public static void registerWorkbenchListener() {
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                AF3ExplorationUIActivator.closeOpenedViews(workbench);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ICommandLineInterfaceService cliService = ICommandLineInterfaceService.getInstance();
        cliService.registerHandler("--load-dse", (ICommandLineSwitchHandler)new CommandLineDSEProjectLoading());
        cliService.registerHandler("--show-dse", (ICommandLineSwitchHandler)new CommandLineDSEPerspective());
    }

    private static void closeOpenedViews(IWorkbench workbench) {
        IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        ArrayList<IViewPart> viewsDsePerspective = new ArrayList<IViewPart>();
        for (String id : IProcessManager.INSTANCE.getAllRegisteredViewIDs()) {
            viewsDsePerspective.add(activePage.findView(id));
        }
        for (IViewPart part : viewsDsePerspective) {
            activePage.hideView(part);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AF3ExplorationUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(path), null));
    }
}

