/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fortiss.af3.exploration.model.ExplorationSpecification;

public class ListSelectionDialog<T>
extends Dialog {
    ComboViewer expSpecComboViewer;
    Button okButton;
    Button cancelButton;
    List<T> elementList;
    T selElement;
    int result = 1;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());

    public ListSelectionDialog(Shell parentShell, List<T> elementList) {
        super(parentShell);
        this.elementList = elementList;
        this.setShellStyle(144);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new RowLayout(512));
        Color whiteBackground = Display.getCurrent().getSystemColor(1);
        container.setBackground(whiteBackground);
        Label description = new Label(container, 0);
        this.formToolkit.adapt((Control)description, true, true);
        description.setText("Select a single RuleSet to validate the Deployment.\n\nNote: RuleSets can be defined in the DSE perspective.");
        this.expSpecComboViewer = new ComboViewer(container, 8);
        Combo combo = this.expSpecComboViewer.getCombo();
        combo.setLayoutData((Object)new RowData(-1, -1));
        this.formToolkit.paintBordersFor((Composite)combo);
        this.initComboViewer();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "OK", false);
        this.cancelButton = this.createButton(parent, 1, "CANCEL", false);
    }

    protected void initComboViewer() {
        if (this.elementList.isEmpty()) {
            return;
        }
        this.expSpecComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.expSpecComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ExplorationSpecification) {
                    ExplorationSpecification expSpec = (ExplorationSpecification)element;
                    return expSpec.toString();
                }
                return super.getText(element);
            }
        });
        this.expSpecComboViewer.setInput(this.elementList);
        StructuredSelection selection = new StructuredSelection(this.elementList.get(0));
        this.expSpecComboViewer.setSelection((ISelection)selection);
    }

    public T getSelElement() {
        return this.selElement;
    }

    public int getResult() {
        return this.result;
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.expSpecComboViewer.getSelection();
        this.selElement = selection.getFirstElement();
        this.result = 0;
        this.close();
    }

    protected void cancelPressed() {
        this.result = 1;
        this.close();
    }
}

