/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.menu;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.smt.solver.DeploymentRun;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.model.annotation.FlashRequirement;
import org.fortiss.af3.task.model.annotation.RamRequirement;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DeploymentValidatorStartMenu
implements IContextMenuContributor {
    private TaskToExecutionUnitAllocationTable ta2hw;
    private Map<String, Collection<? extends IExplorationTarget<?>>> defaultConstraints;
    private static int SOLVER_TIMEOUT = 10000;
    private static String ACTION_NAME = "Validate TA \u2192 HW Allocation";

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof TaskToExecutionUnitAllocationTable) {
            this.ta2hw = (TaskToExecutionUnitAllocationTable)selection;
            if (this.hasAllTasksAllocated(this.ta2hw)) {
                ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new DeploymentValidationAction()));
                return contributionItems;
            }
        }
        return Collections.emptyList();
    }

    private boolean hasAllTasksAllocated(TaskToExecutionUnitAllocationTable ta2hw) {
        return ta2hw.getTaskArchitecture().getTasks().stream().allMatch(t -> ta2hw.getTasks().contains(t));
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    protected ImageDescriptor getActionIcon() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD");
    }

    private DSE createDSEWithCopies(AllocationTableCollection atc, ComponentArchitecture ca, TaskArchitecture ta, PlatformArchitecture pa) {
        FileProject fp = (FileProject)EcoreUtils.getFirstParentWithType((EObject)atc, FileProject.class);
        DSE dse = DSEProjectModelElementFactory.createDSE((String)"DSE", (FileProject)fp);
        Map copies = EcoreUtils.copyToRefMap(Arrays.asList(atc, ca, ta, pa));
        ModelSnapshot caSnap = ModelSnapshotExtractUtils.createComponentArchitectureSnapshot((ComponentArchitecture)((ComponentArchitecture)copies.get(ca)));
        dse.getInitialStep().addSnapshot(caSnap);
        ModelSnapshot taSnap = ModelSnapshotExtractUtils.createTaskArchitectureSnapshot((TaskArchitecture)((TaskArchitecture)copies.get(ta)));
        dse.getInitialStep().addSnapshot(taSnap);
        ModelSnapshot paSnap = ModelSnapshotExtractUtils.createPlatformArchitectureSnapshot((PlatformArchitecture)((PlatformArchitecture)copies.get(pa)));
        dse.getInitialStep().addSnapshot(paSnap);
        ModelSnapshot allocSnap = ModelSnapshotExtractUtils.createAllocationTableCollectionSnapshot((AllocationTableCollection)((AllocationTableCollection)copies.get(atc)), Arrays.asList(ComponentToTaskAllocationEntry.class, TaskToExecutionUnitAllocationEntry.class), Arrays.asList(caSnap, taSnap, paSnap));
        dse.getInitialStep().addSnapshot(allocSnap);
        return dse;
    }

    private Map<String, Collection<? extends IExplorationTarget<?>>> createDefaultConstraints(DSE dse) {
        Map<String, Collection<? extends IExplorationTarget<?>>> explorationTargets = Map.ofEntries(this.createDefaultSafetyConstraint(dse), this.createDefaultResourceConstraint(dse, RamSize.class, RamRequirement.class), this.createDefaultResourceConstraint(dse, FlashSize.class, FlashRequirement.class));
        return explorationTargets;
    }

    private Map.Entry<String, Collection<? extends IExplorationTarget<?>>> createDefaultResourceConstraint(DSE dse, Class<? extends IAnnotatedSpecification> availabilityAnnotation, Class<? extends IAnnotatedSpecification> requirementAnnotation) {
        List<Object> targetConstraints;
        String targetName = String.format("Default Resource Constraint: %s / %s", requirementAnnotation.getSimpleName(), availabilityAnnotation.getSimpleName());
        SuperSetMap ssMap = dse.getCurrentStep().getSuperSetMap();
        EList executionUnits = ssMap.get(ExecutionUnit.class).getEntries();
        EList tasks = ssMap.get(Task.class).getEntries();
        Predicate<Long> hasValue = v -> v == null || v == 0L;
        boolean isAvailabilityAnnotated = executionUnits.stream().map(e -> (Long)AnnotationUtils.getAnnotationValue((IModelElement)e, (Class)availabilityAnnotation, Long.class)).noneMatch(hasValue);
        boolean isRequirementAnnotated = tasks.stream().map(t -> (Long)AnnotationUtils.getAnnotationValue((IModelElement)t, (Class)requirementAnnotation, Long.class)).noneMatch(hasValue);
        if (!isAvailabilityAnnotated || !isRequirementAnnotated) {
            targetConstraints = Collections.emptyList();
        } else {
            HashMap resourceUtilization = new HashMap();
            executionUnits.forEach(executionUnit -> {
                Integer n = resourceUtilization.put(executionUnit, 100);
            });
            BooleanLiteral expression = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
            for (ExecutionUnit executionUnit2 : executionUnits) {
                double utilization = (double)((Integer)resourceUtilization.get(executionUnit2)).intValue() / 100.0;
                expression = DSMLModelElementFactory.createAnd((IBooleanExpression)expression, (IBooleanExpression)PatternFactoryUtils.createUtilizationPatternExpression((DSE)dse, (double)utilization, (ExecutionUnit)executionUnit2, requirementAnnotation, availabilityAnnotation));
            }
            ExplorationConstraint resourceConstraint = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)targetName, (boolean)false);
            targetConstraints = Arrays.asList(resourceConstraint);
        }
        return Map.entry(targetName, targetConstraints);
    }

    private Map.Entry<String, Collection<? extends IExplorationTarget<?>>> createDefaultSafetyConstraint(DSE dse) {
        List<Object> targetConstraints;
        String targetName = "Default Safety Constraint";
        SuperSetMap ssMap = dse.getCurrentStep().getSuperSetMap();
        EList executionUnits = ssMap.get(ExecutionUnit.class).getEntries();
        EList components = ssMap.get(Component.class).getEntries();
        Predicate<IModelElement> hasSafetyAnnotation = me -> AnnotationUtils.getAnnotationValue((IModelElement)me, SafetyIntegrityLevel.class, Enumerator.class) == null;
        boolean isAvailabilityAnnotated = executionUnits.stream().noneMatch(hasSafetyAnnotation);
        boolean isRequirementAnnotated = components.stream().noneMatch(hasSafetyAnnotation);
        if (!isAvailabilityAnnotated || !isRequirementAnnotated) {
            targetConstraints = Collections.emptyList();
        } else {
            BooleanLiteral expression = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
            for (ExecutionUnit executionUnit : executionUnits) {
                expression = DSMLModelElementFactory.createAnd((IBooleanExpression)expression, (IBooleanExpression)PatternFactoryUtils.createSafetyPatternExpression((DSE)dse, (ExecutionUnit)executionUnit, (SuperSet)ssMap.get(ComponentToTaskAllocationEntry.class)));
            }
            ExplorationConstraint safetyConstraint = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)targetName, (boolean)false);
            targetConstraints = Arrays.asList(safetyConstraint);
        }
        return Map.entry(targetName, targetConstraints);
    }

    private Collection<? extends IExplorationTarget<?>> createAllocationConstraints(DSE dse) {
        return dse.getCurrentStep().getSuperSetMap().get(TaskToExecutionUnitAllocationEntry.class).getEntries().stream().map(entry -> ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)PatternFactoryUtils.createAllocationPatternExpression((DSE)dse, (boolean)true, (List)entry.getTasks(), Arrays.asList(entry.getExecutionUnit())), (String)"Manual Allocation Constraint", (boolean)false)).collect(Collectors.toSet());
    }

    private void showErrorInformation() {
        MessageUtils.showError((String)"Validation Result", (String)"The validation of the selected task-to-hardware allocation encountered an error and could not be completed.");
    }

    private void showSuccessInformation() {
        MessageUtils.showInfo((String)"Validation Result", (String)String.format("The selected task-to-hardware allocation SATISFIES the following deployment constraints: %s\nThe following constraints were skipped due to missing/incomplete annotations: %s", this.getAppliedConstraintNames(), this.getSkippedConstraintNames()));
    }

    private void showFailureInformation() {
        MessageUtils.showWarning((String)"Validation Result", (String)String.format("The selected task-to-hardware allocation VIOLATES one or more of the following deployment constraints: %s\nThe following constraints were skipped due to missing/incomplete annotations: %s", this.getAppliedConstraintNames(), this.getSkippedConstraintNames()));
    }

    private String getAppliedConstraintNames() {
        return this.getFilteredConstraintList(this.defaultConstraints, e -> !((Collection)e.getValue()).isEmpty());
    }

    private String getSkippedConstraintNames() {
        return this.getFilteredConstraintList(this.defaultConstraints, e -> ((Collection)e.getValue()).isEmpty());
    }

    private String getFilteredConstraintList(Map<String, Collection<? extends IExplorationTarget<?>>> constraints, Predicate<? super Map.Entry<String, Collection<? extends IExplorationTarget<?>>>> filter) {
        return "\n - " + constraints.entrySet().stream().filter(filter).map(e -> (String)e.getKey()).collect(Collectors.joining("\n - "));
    }

    private void logFailure(Exception e) {
        LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)"Validation Failure", (Throwable)e);
    }

    protected class DeploymentValidationAction
    extends Action {
        public DeploymentValidationAction() {
            super(ACTION_NAME, DeploymentValidatorStartMenu.this.getActionIcon());
        }

        public void run() {
            AllocationTableCollection atc = DeploymentValidatorStartMenu.this.ta2hw.getAllocationTableCollection();
            ComponentToTaskAllocationTable ca2ta = (ComponentToTaskAllocationTable)atc.getAllocationTable(ComponentToTaskAllocationTable.class);
            ComponentArchitecture ca = ca2ta.getComponentArchitecture();
            TaskArchitecture ta = DeploymentValidatorStartMenu.this.ta2hw.getTaskArchitecture();
            PlatformArchitecture pa = DeploymentValidatorStartMenu.this.ta2hw.getPlatformArchitecture();
            DSE dse = DeploymentValidatorStartMenu.this.createDSEWithCopies(atc, ca, ta, pa);
            final ExplorationSpecification expSpec = ExplorationModelElementFactory.createExplorationSpecification();
            expSpec.setSearchSpace(dse.getCurrentStep().getSuperSetMap());
            DeploymentValidatorStartMenu.this.defaultConstraints = DeploymentValidatorStartMenu.this.createDefaultConstraints(dse);
            expSpec.getTargets().addAll((Collection)DeploymentValidatorStartMenu.this.defaultConstraints.values().stream().flatMap(c -> c.stream()).collect(Collectors.toSet()));
            Collection<? extends IExplorationTarget<?>> allocationConstraints = DeploymentValidatorStartMenu.this.createAllocationConstraints(dse);
            expSpec.getTargets().addAll(allocationConstraints);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        DeploymentRun solver = new DeploymentRun(expSpec, SOLVER_TIMEOUT);
                        Optional solution = solver.solve((IProgressMonitor)new NullProgressMonitor());
                        if (solution.isPresent()) {
                            if (((ExplorationSolution)solution.get()).getSolutionState() == SolutionState.OPTIMAL) {
                                DeploymentValidatorStartMenu.this.showSuccessInformation();
                                return;
                            }
                            DeploymentValidatorStartMenu.this.showFailureInformation();
                            return;
                        }
                        DeploymentValidatorStartMenu.this.showErrorInformation();
                    }
                    catch (Exception e) {
                        DeploymentValidatorStartMenu.this.logFailure(e);
                    }
                }
            });
        }
    }
}

