/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard;

import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizard;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DashboardFXController
extends CompositeFXControllerBase<AnchorPane, Node>
implements IEventListener {
    @FXML
    private Button constraintsButton;
    @FXML
    private Button objectivesButton;
    @FXML
    private Button synthesisButton;
    @FXML
    private Button visualizationButton;
    @FXML
    private Button selectAF3Button;
    @FXML
    private Button importButton;
    @FXML
    private Label selectedProjectLabel;

    public DashboardFXController() {
        super(new ICompositeFXController[0]);
    }

    public void onConstaintsButton() {
        IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.CONSTRAINTS);
    }

    public void onObjectivesButton() {
        IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.OBJECTIVES);
    }

    public void onSynthesisButton() {
        IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.SYNTHESIS);
    }

    public void onVisualizationButton() {
        IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.VISUALIZATION);
    }

    public void onSelectAF3Button() {
        DashboardWizard wizard = new DashboardWizard();
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        try {
            dialog.open();
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)"Opening the DSE AF3 import wizard failed.", (Throwable)e);
        }
        if (dialog.getReturnCode() == 0) {
            this.updatePrjLabel(IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE());
        }
        wizard.dispose();
    }

    public String getFXMLLocation() {
        return "DashboardLayout.fxml";
    }

    public void initialize() {
        EventBroker.getInstance().addListener((IEventListener)this, true);
        DSE activeDSE = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        this.updatePrjLabel(activeDSE);
        if (activeDSE != null) {
            this.enableViewButtons(true);
        }
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT propId) {
        if (propId == IEventListener.DSE_EVENT.DSE_SELECTED_EVENT && source instanceof DSE) {
            this.updatePrjLabel((DSE)source);
            this.enableViewButtons(true);
        } else if (propId == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT) {
            this.updatePrjLabel(null);
            this.enableViewButtons(false);
        }
    }

    private void updatePrjLabel(DSE dse) {
        if (dse != null) {
            FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)dse, FileProject.class, (boolean)false);
            this.selectedProjectLabel.setText(fp.getName());
        } else {
            this.selectedProjectLabel.setText("None");
            Platform.runLater(() -> this.selectedProjectLabel.requestLayout());
        }
    }

    private void enableViewButtons(boolean enable) {
        this.objectivesButton.setDisable(!enable);
        this.constraintsButton.setDisable(!enable);
        this.synthesisButton.setDisable(!enable);
        this.visualizationButton.setDisable(!enable);
    }
}

