/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.InitialInputDefinitionStep;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectAllocation;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectComponentArchitecture;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectDataDictionary;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectFunctionArchitecture;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectPartitionArchitecture;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectPlatformArchitecture;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectProjectSource;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectTaskArchitecture;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardSelectTimingSpecification;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.IDashboardWizardImportPage;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class DashboardWizard
extends Wizard {
    private FileProject originalFileProject;
    private DSE dse;
    private ImportState currentState = ImportState.INIT;
    private Map<Class<? extends IProjectRootElement>, IProjectRootElement> selectedElements = new LinkedHashMap<Class<? extends IProjectRootElement>, IProjectRootElement>();
    private Map<Class<? extends IProjectRootElement>, IDashboardWizardImportPage.Converter<? extends IProjectRootElement>> converterMap = new HashMap<Class<? extends IProjectRootElement>, IDashboardWizardImportPage.Converter<? extends IProjectRootElement>>();

    public DashboardWizard() {
        this.setWindowTitle("Import Wizard");
    }

    public void addPages() {
        this.addPage((IWizardPage)new DashboardWizardSelectProjectSource());
        this.registerConverter(new DashboardWizardSelectDataDictionary());
        this.registerConverter(new DashboardWizardSelectFunctionArchitecture());
        this.registerConverter(new DashboardWizardSelectComponentArchitecture());
        this.registerConverter(new DashboardWizardSelectTaskArchitecture());
        this.registerConverter(new DashboardWizardSelectPartitionArchitecture());
        this.registerConverter(new DashboardWizardSelectPlatformArchitecture());
        this.registerConverter(new DashboardWizardSelectAllocation());
        this.registerConverter(new DashboardWizardSelectTimingSpecification());
        IWizardPage[] pages = this.getPages();
        int i = 1;
        while (i < pages.length) {
            if (!(pages[i] instanceof IDashboardWizardImportPage)) {
                LoggingUtils.showError((String)("An import page has been defined for the DSE perspictive that is not a " + IDashboardWizardImportPage.class.getSimpleName() + "."));
                return;
            }
            ++i;
        }
    }

    private <T extends IDashboardWizardImportPage<?> & IWizardPage> void registerConverter(T page) {
        this.converterMap.put(page.getRootElementType(), page.getModelToSnapShotConverter());
        this.addPage(page);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage;
        IDashboardWizardImportPage impPage;
        if (page instanceof DashboardWizardSelectProjectSource) {
            DashboardWizardSelectProjectSource prjPage = (DashboardWizardSelectProjectSource)page;
            if (this.currentState == ImportState.EXISTING_DSE_SELECTED) {
                this.dse = prjPage.getSelectedDSE();
                return null;
            }
            if (this.currentState == ImportState.IN_PROGRESS) {
                if (!this.allRequiredInputsAvailable(prjPage.getSelectedFileProject())) {
                    return page;
                }
                this.originalFileProject = prjPage.getSelectedFileProject();
                this.dse = DSEProjectModelElementFactory.createDSE((String)"DSE", (FileProject)this.originalFileProject);
            }
        }
        if (page instanceof IDashboardWizardImportPage && (impPage = (IDashboardWizardImportPage)page).getSelectedElement() != null) {
            Assert.isTrue((boolean)impPage.getRootElementType().isAssignableFrom(impPage.getSelectedElement().getClass()));
            this.selectedElements.put(impPage.getRootElementType(), impPage.getSelectedElement());
        }
        if ((nextPage = super.getNextPage(page)) == null) {
            return null;
        }
        IDashboardWizardImportPage nextImportPage = (IDashboardWizardImportPage)nextPage;
        EList rootElements = EcoreUtils.pickInstanceOf(nextImportPage.getRootElementType(), (List)this.originalFileProject.getRootElements());
        boolean inputsAvailable = nextImportPage.inputsAvailable((List<IProjectRootElement>)rootElements);
        if (!inputsAvailable) {
            if (!nextImportPage.isRequired()) {
                ((WizardPage)nextPage).setPageComplete(true);
            }
            return this.getNextPage(nextPage);
        }
        return nextPage;
    }

    public boolean performFinish() {
        if (this.currentState != ImportState.EXISTING_DSE_SELECTED) {
            Map copyRefMap = EcoreUtils.copyToRefMap(this.selectedElements.values());
            InitialInputDefinitionStep initialStep = this.dse.getInitialStep();
            for (Map.Entry<Class<? extends IProjectRootElement>, IProjectRootElement> entry : this.selectedElements.entrySet()) {
                IProjectRootElement rootElement = entry.getValue();
                IProjectRootElement copiedRootElement = (IProjectRootElement)copyRefMap.get(rootElement);
                IDashboardWizardImportPage.Converter<? extends IProjectRootElement> converter = this.converterMap.get(entry.getKey());
                if (converter == null) {
                    LoggingUtils.showError((String)("A converter for " + rootElement.getName() + " is missing to create a " + ModelSnapshot.class.getSimpleName() + "."));
                    return false;
                }
                EList prevSnaps = initialStep.getModelSnapshots();
                try {
                    KernelModelElementUtils.runAsCommand((EObject)this.originalFileProject, () -> DashboardWizard.lambda$0(converter, copiedRootElement, (Collection)prevSnaps, copyRefMap, initialStep));
                }
                catch (Exception e) {
                    org.conqat.ide.commons.ui.logging.LoggingUtils.logAndShowError((Plugin)AF3ExplorationUIActivator.getDefault(), (String)("Creating the " + ModelSnapshot.class.getSimpleName() + " failed for the root element " + rootElement.getName() + "."), (Throwable)e);
                    return false;
                }
            }
            KernelModelElementUtils.runAsCommand((EObject)this.originalFileProject, () -> {
                UniqueIDUtils.prepareUniqueID((EObject)this.dse, (EObject)this.originalFileProject);
                this.originalFileProject.getRootElements().add((Object)this.dse);
            });
        }
        IDSEPerspectiveManager.INSTANCE.setCurrentlySelectedDSE(this.dse);
        return true;
    }

    public boolean canFinish() {
        IWizardPage lastPage = this.getPages()[this.getPageCount() - 1];
        boolean allComplete = Arrays.asList(this.getPages()).stream().allMatch(page -> page.isPageComplete());
        if (this.getNextPage(lastPage) == null && allComplete) {
            this.currentState = ImportState.ALL_ARTIFACTS_IMPORTED;
        }
        switch (this.currentState) {
            case EXISTING_DSE_SELECTED: {
                return true;
            }
            case ALL_ARTIFACTS_IMPORTED: {
                return true;
            }
            case IN_PROGRESS: {
                return false;
            }
        }
        return false;
    }

    protected boolean allRequiredInputsAvailable(FileProject fp) {
        IWizardPage[] pages = this.getPages();
        int i = 1;
        while (i < pages.length) {
            IDashboardWizardImportPage page = (IDashboardWizardImportPage)pages[i];
            EList rootElements = EcoreUtils.pickInstanceOf(page.getRootElementType(), (List)fp.getRootElements());
            boolean inputsAvailable = page.inputsAvailable((List<IProjectRootElement>)rootElements);
            if (!inputsAvailable && page.isRequired()) {
                LoggingUtils.showError((String)("The selected file project \"" + fp.getName() + "\" does not contain a root element of type \"" + page.getRootElementType().getSimpleName() + "\". Therefore, it cannot be imported."));
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<IProjectRootElement> getSelectedIProjectRootElements() {
        return new ArrayList<IProjectRootElement>(this.selectedElements.values());
    }

    public void setState(ImportState state) {
        this.currentState = state;
    }

    public <T extends IProjectRootElement> List<T> getInputModels(Class<T> rootElementType) {
        return KernelModelElementUtils.getRootElements((EObject)this.originalFileProject, rootElementType);
    }

    public Collection<ModelSnapshot> getSnapshots() {
        EList inputs = this.dse.getCurrentStep().getInputArtifacts();
        return EcoreUtils.pickInstanceOf(ModelSnapshot.class, (List)inputs);
    }

    public void addSnapshot(ModelSnapshot snapshot) {
        EList inputs = this.dse.getCurrentStep().getInputArtifacts();
        inputs.add((Object)snapshot);
    }

    private static /* synthetic */ void lambda$0(IDashboardWizardImportPage.Converter converter, IProjectRootElement iProjectRootElement, Collection collection, Map map, InitialInputDefinitionStep initialInputDefinitionStep) {
        ModelSnapshot snapshot = converter.apply(iProjectRootElement, collection, map);
        initialInputDefinitionStep.addSnapshot(snapshot);
    }

    public static enum ImportState {
        INIT,
        EXISTING_DSE_SELECTED,
        IN_PROGRESS,
        ALL_ARTIFACTS_IMPORTED;

    }
}

