/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizard;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.IDashboardWizardImportPage;
import org.fortiss.af3.exploration.ui.perspective.generic.HierarchicElementContentProvider;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public abstract class DashboardWizardRootElementSelectionBase<T extends IProjectRootElement>
extends WizardPage
implements IDashboardWizardImportPage<T> {
    private TreeViewer treeViewer;
    protected T selectedRootElement;
    private List<IModelElement> selectedElements;
    private Class<T> rootElementType;
    private String rootElementTypeName;
    private boolean isUserSelection = true;

    public DashboardWizardRootElementSelectionBase(String rootElementTypeName, Class<T> rootElementType) {
        super("Import");
        this.setTitle("IMPORT " + rootElementTypeName);
        Object description = "Select the ";
        if (this.isSelectElements()) {
            description = (String)description + "entire ";
        }
        description = (String)description + rootElementTypeName.toLowerCase();
        if (this.isSelectElements()) {
            description = (String)description + " or individual elements (CTRL + left-click)";
        }
        description = (String)description + ".";
        this.setDescription((String)description);
        this.rootElementType = rootElementType;
        this.rootElementTypeName = rootElementTypeName;
        this.setPageComplete(false);
    }

    protected abstract boolean isRelevantElement(EObject var1);

    protected abstract boolean isRelevantRootElement(T var1);

    protected abstract boolean isSelectElements();

    protected String noticeReducedFunctionality(T rootElement) {
        return null;
    }

    protected ITreeContentProvider createContentProvider() {
        return new HierarchicElementContentProvider();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer(container, 2050);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider(){

            public Color getBackground(Object object) {
                if (!(object instanceof EObject) || DashboardWizardRootElementSelectionBase.this.selectedRootElement == null) {
                    return super.getBackground(object);
                }
                EObject element = (EObject)object;
                IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)element, DashboardWizardRootElementSelectionBase.this.rootElementType, (boolean)true);
                if (DashboardWizardRootElementSelectionBase.this.selectedRootElement == rootElement && DashboardWizardRootElementSelectionBase.this.selectedElements.isEmpty() && (element == rootElement || DashboardWizardRootElementSelectionBase.this.isRelevantElement(element))) {
                    return SWTResourceManager.getColor((int)7);
                }
                return super.getBackground(object);
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private boolean userNoticeShown = false;

            public void selectionChanged(SelectionChangedEvent event) {
                String noticeMessage;
                if (!DashboardWizardRootElementSelectionBase.this.isUserSelection) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                List elements = (List)LambdaUtils.filterType((Collection)((StructuredSelection)selection).toList(), EObject.class);
                IProjectRootElement rootElement = (IProjectRootElement)EcoreUtils.pickFirstInstanceOf(DashboardWizardRootElementSelectionBase.this.rootElementType, (List)elements);
                elements.remove(rootElement);
                if (rootElement == null && !elements.isEmpty()) {
                    rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)((EObject)elements.get(0)), DashboardWizardRootElementSelectionBase.this.rootElementType, (boolean)true);
                }
                DashboardWizardRootElementSelectionBase.this.selectedElements = DashboardWizardRootElementSelectionBase.this.isSelectElements() ? EcoreUtils.pickInstanceOf(IModelElement.class, (List)elements) : Collections.emptyList();
                String name = DashboardWizardRootElementSelectionBase.this.rootElementTypeName.toLowerCase();
                String errorMessage = null;
                if (rootElement == null) {
                    errorMessage = "Please select the " + name + " to be used for DSE.";
                } else {
                    if (!DashboardWizardRootElementSelectionBase.this.isRelevantRootElement(rootElement)) {
                        errorMessage = "The selected " + name + " cannot be used as DSE input.";
                        rootElement = null;
                    }
                    DashboardWizardRootElementSelectionBase.this.showRootElement(rootElement);
                }
                DashboardWizardRootElementSelectionBase.this.setErrorMessage(errorMessage);
                DashboardWizardRootElementSelectionBase.this.selectedRootElement = rootElement;
                if (StringUtils.isEmpty((CharSequence)errorMessage) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{noticeMessage = DashboardWizardRootElementSelectionBase.this.noticeReducedFunctionality(rootElement)}) && !this.userNoticeShown) {
                    LoggingUtils.showWarning((String)noticeMessage);
                    this.userNoticeShown = true;
                }
                Set rootElements = DashboardWizardRootElementSelectionBase.this.selectedElements.stream().map(e -> {
                    if (e instanceof IProjectRootElement) {
                        return e;
                    }
                    return EcoreUtils.getFirstParentWithType((EObject)e, IProjectRootElement.class);
                }).collect(Collectors.toSet());
                if (DashboardWizardRootElementSelectionBase.this.selectedRootElement != null) {
                    rootElements.add(DashboardWizardRootElementSelectionBase.this.selectedRootElement);
                }
                DashboardWizardRootElementSelectionBase.this.treeViewer.refresh(true);
                DashboardWizardRootElementSelectionBase.this.setPageComplete(rootElements.size() == 1 || !DashboardWizardRootElementSelectionBase.this.isRequired());
            }
        });
        this.treeViewer.addDoubleClickListener(e -> {
            if (e.getSelection() != null && this.canFlipToNextPage()) {
                IWizardPage nextPage = this.getNextPage();
                this.getContainer().showPage(nextPage);
            }
        });
    }

    protected void showRootElement(T rootElement) {
        if (rootElement != null) {
            Tree tree = this.treeViewer.getTree();
            tree.setRedraw(false);
            this.isUserSelection = false;
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.addAll(this.selectedElements);
            elements.add(rootElement);
            this.treeViewer.setSelection((ISelection)new StructuredSelection(elements), true);
            this.isUserSelection = true;
            this.treeViewer.expandToLevel(rootElement, -1);
            this.treeViewer.reveal(rootElement);
            tree.setRedraw(true);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.treeViewer.setInput(this.getDashboardWizard().getInputModels(this.rootElementType));
        this.showRootElement(this.selectedRootElement);
    }

    public DashboardWizard getDashboardWizard() {
        return (DashboardWizard)this.getWizard();
    }

    @Override
    public Class<T> getRootElementType() {
        return this.rootElementType;
    }

    @Override
    public IProjectRootElement getSelectedElement() {
        return this.selectedRootElement;
    }

    public <U extends IModelElement> List<U> getSelectedElements(Map<EObject, EObject> copyRefMap, Class<U> type) {
        if (this.selectedElements.isEmpty()) {
            return null;
        }
        return this.selectedElements.stream().map(e -> (EObject)copyRefMap.get(e)).filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }
}

