/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardRootElementSelectionBase;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.IDashboardWizardImportPage;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.function.model.FunctionArchitecture;
import org.fortiss.af3.function.model.allocation.FunctionToComponentAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.InputPortToTaskInputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.OutputPortToTaskOutputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class DashboardWizardSelectAllocation
extends DashboardWizardRootElementSelectionBase<AllocationTableCollection> {
    private Collection<Class<? extends AllocationEntry>> relevantTypes = new HashSet<Class<? extends AllocationEntry>>();

    public DashboardWizardSelectAllocation() {
        super("Input Allocation Set", AllocationTableCollection.class);
        this.relevantTypes.add(FunctionToComponentAllocationEntry.class);
        this.relevantTypes.add(ComponentToTaskAllocationEntry.class);
        this.relevantTypes.add(InputPortToTaskInputPortAllocationEntry.class);
        this.relevantTypes.add(OutputPortToTaskOutputPortAllocationEntry.class);
        this.relevantTypes.add(TaskToExecutionUnitAllocationEntry.class);
        this.relevantTypes.add(SignalToRouteAllocationEntry.class);
        this.relevantTypes.add(TaskToPartitionAllocationEntry.class);
        this.relevantTypes.add(PartitionToExecutionUnitAllocationEntry.class);
    }

    @Override
    protected boolean isRelevantElement(EObject element) {
        if (!(element instanceof AllocationTable)) {
            return false;
        }
        AllocationTable at = (AllocationTable)element;
        return this.isRelevantAllocationTable(at, FunctionArchitecture.class, ComponentArchitecture.class) || this.isRelevantAllocationTable(at, ComponentArchitecture.class, TaskArchitecture.class);
    }

    @Override
    protected boolean isRelevantRootElement(AllocationTableCollection allocTable) {
        return allocTable.getAllocationTables().stream().anyMatch(at -> this.isRelevantAllocationTable((AllocationTable)at, (Class)ComponentArchitecture.class, (Class)TaskArchitecture.class));
    }

    private <S extends IProjectRootElement, T extends IProjectRootElement> boolean isRelevantAllocationTable(AllocationTable at, Class<S> sClazz, Class<T> tClazz) {
        List<IProjectRootElement> rootElements = this.getDashboardWizard().getSelectedIProjectRootElements();
        IProjectRootElement sArch = (IProjectRootElement)EcoreUtils.pickFirstInstanceOf(sClazz, rootElements);
        IProjectRootElement sourceView = at.getSourceView();
        if (sourceView == null) {
            return false;
        }
        IProjectRootElement tArch = (IProjectRootElement)EcoreUtils.pickFirstInstanceOf(tClazz, rootElements);
        IProjectRootElement targetView = at.getTargetView();
        if (targetView == null) {
            return false;
        }
        return sourceView.equals(sArch) && targetView.equals(tArch);
    }

    @Override
    public IDashboardWizardImportPage.Converter<AllocationTableCollection> getModelToSnapShotConverter() {
        return new IDashboardWizardImportPage.Converter<AllocationTableCollection>(){

            @Override
            public ModelSnapshot apply(AllocationTableCollection t, Collection<ModelSnapshot> prevSnaps, Map<EObject, EObject> copyRefMap) {
                return ModelSnapshotExtractUtils.createAllocationTableCollectionSnapshot((AllocationTableCollection)t, DashboardWizardSelectAllocation.this.relevantTypes, prevSnaps);
            }
        };
    }

    @Override
    public boolean inputsAvailable(List<? extends IProjectRootElement> rootElements) {
        EList allocTables = EcoreUtils.pickInstanceOf(AllocationTableCollection.class, rootElements);
        return allocTables.stream().anyMatch(atc -> this.isRelevantRootElement((AllocationTableCollection)atc));
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    protected boolean isSelectElements() {
        return false;
    }
}

