/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardRootElementSelectionBase;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.IDashboardWizardImportPage;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.safety.model.SafetyStandard;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.util.TaskArchitectureUtils;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class DashboardWizardSelectPlatformArchitecture
extends DashboardWizardRootElementSelectionBase<PlatformArchitecture> {
    public DashboardWizardSelectPlatformArchitecture() {
        super("Technical Architecture", PlatformArchitecture.class);
    }

    @Override
    protected boolean isRelevantElement(EObject element) {
        PlatformArchitecture pa = (PlatformArchitecture)KernelModelElementUtils.getParentElement((EObject)element, PlatformArchitecture.class, (boolean)false);
        return TaskArchitectureUtils.findTargetExecutionUnits((PlatformArchitecture)pa).contains(element) || PlatformArchitectureUtils.findAllGatewayUnits((PlatformArchitecture)pa).contains(element) || PlatformArchitectureUtils.findAtomicTransmissionUnits((PlatformArchitecture)pa).contains(element);
    }

    @Override
    protected boolean isRelevantRootElement(PlatformArchitecture platformArchitecture) {
        return !TaskArchitectureUtils.findTargetExecutionUnits((PlatformArchitecture)platformArchitecture).isEmpty();
    }

    @Override
    protected String noticeReducedFunctionality(PlatformArchitecture rootElement) {
        SafetyIntegrityLevel sil = (SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)rootElement, SafetyIntegrityLevel.class);
        if (sil.getSafetyStandard() == SafetyStandard.UNDEFINED) {
            return "The safety standard of the platform architecture is not defined.\nTo use the safety level constraints, please define the safety standard and the level in the modelling perspective.";
        }
        return null;
    }

    @Override
    public IDashboardWizardImportPage.Converter<PlatformArchitecture> getModelToSnapShotConverter() {
        return new IDashboardWizardImportPage.Converter<PlatformArchitecture>(){

            @Override
            public ModelSnapshot apply(PlatformArchitecture p, Collection<ModelSnapshot> prevSnaps, Map<EObject, EObject> copyRefMap) {
                return ModelSnapshotExtractUtils.createPlatformArchitectureSnapshot((PlatformArchitecture)p, DashboardWizardSelectPlatformArchitecture.this.getSelectedElements(copyRefMap, IHierarchicElement.class));
            }
        };
    }

    @Override
    public boolean inputsAvailable(List<? extends IProjectRootElement> rootElements) {
        EList platArchs = EcoreUtils.pickInstanceOf(PlatformArchitecture.class, rootElements);
        for (PlatformArchitecture pa : platArchs) {
            if (!this.isRelevantRootElement(pa)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    protected boolean isSelectElements() {
        return true;
    }
}

