/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizard;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class DashboardWizardSelectProjectSource
extends WizardPage {
    private TreeViewer tableViewer;
    private boolean isInit = true;
    private FileProject selectedFileProject;
    private DSE selectedDSE;
    final String STANDARD_DESCRIPTION = "Select project for which a new DSE will be created, or existing DSE to be loaded.";

    public DashboardWizardSelectProjectSource() {
        super("Import");
        this.setTitle("IMPORT");
        this.setDescription("Select the project to be used for DSE");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TreeViewer(container, 67584);
        Tree table = this.tableViewer.getTree();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.setDescription("Select project for which a new DSE will be created, or existing DSE to be loaded.");
        this.tableViewer.addDoubleClickListener(e -> {
            if (e.getSelection() != null && this.canFlipToNextPage()) {
                IWizardPage nextPage = this.getNextPage();
                this.getContainer().showPage(nextPage);
            }
        });
        this.fillContents();
        if (this.tableViewer.getInput() != null) {
            this.tableViewer.getControl().setFocus();
        }
        this.setPageComplete(false);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
    }

    private void fillContents() {
        List topLevelElements = IPersistencyService.getInstance().getTopLevelElements();
        ArrayList<FileProject> projects = new ArrayList<FileProject>();
        for (ITopLevelElement e : topLevelElements) {
            if (!(e.getRootModelElement() instanceof FileProject)) continue;
            projects.add((FileProject)e.getRootModelElement());
        }
        this.tableViewer.setInput(projects);
    }

    public FileProject getSelectedFileProject() {
        return this.selectedFileProject;
    }

    public DSE getSelectedDSE() {
        return this.selectedDSE;
    }

    private final class ColumnLabelProvider
    extends ModelElementLabelProvider {
        private ColumnLabelProvider() {
        }

        public Color getForeground(Object element) {
            if (!(element instanceof FileProject)) {
                return super.getForeground(element);
            }
            FileProject fp = (FileProject)element;
            List dseList = KernelModelElementUtils.getRootElements((EObject)fp, DSE.class);
            if (dseList.isEmpty()) {
                return SWTResourceManager.getColor((int)15);
            }
            return super.getForeground(element);
        }

        public Color getBackground(Object element) {
            FileProject project;
            if (!(element instanceof FileProject)) {
                return super.getBackground(element);
            }
            FileProject fp = (FileProject)element;
            List dseList = KernelModelElementUtils.getRootElements((EObject)fp, DSE.class);
            DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
            if (dse != null && element.equals(project = (FileProject)KernelModelElementUtils.getParentElement((EObject)dse, FileProject.class, (boolean)false)) && !dseList.isEmpty()) {
                return SWTResourceManager.getColor((int)7);
            }
            return super.getBackground(element);
        }

        public String getText(Object element) {
            String text = super.getText(element);
            String[] split = text.split(":");
            if (split.length > 1) {
                return split[0];
            }
            return text;
        }
    }

    private final class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            if (DashboardWizardSelectProjectSource.this.isInit) {
                DashboardWizardSelectProjectSource.this.isInit = false;
                Object source = event.getSource();
                if (source instanceof TreeViewer) {
                    ((TreeViewer)source).setSelection(null);
                }
                return;
            }
            DashboardWizard wizard = (DashboardWizard)DashboardWizardSelectProjectSource.this.getWizard();
            DashboardWizardSelectProjectSource.this.setPageComplete(false);
            DSE dse = (DSE)SelectionUtils.checkAndPickFirst((ISelection)selection, DSE.class);
            if (dse != null) {
                DashboardWizardSelectProjectSource.this.selectedDSE = dse;
                wizard.setState(DashboardWizard.ImportState.EXISTING_DSE_SELECTED);
                IModelElementHandlerService hs = IModelElementHandlerService.getInstance();
                DashboardWizardSelectProjectSource.this.setDescription("DSE configuration <" + hs.getName((EObject)dse) + "> will be loaded.");
                DashboardWizardSelectProjectSource.this.getContainer().updateButtons();
            } else {
                FileProject fp = (FileProject)SelectionUtils.checkAndPickFirst((ISelection)selection, FileProject.class);
                if (fp != null) {
                    DashboardWizardSelectProjectSource.this.selectedFileProject = fp;
                    wizard.setState(DashboardWizard.ImportState.IN_PROGRESS);
                    DashboardWizardSelectProjectSource.this.setDescription("Start importer for a new DSE project.");
                    DashboardWizardSelectProjectSource.this.getContainer().updateButtons();
                }
            }
            DashboardWizardSelectProjectSource.this.setPageComplete(true);
            DashboardWizardSelectProjectSource.this.tableViewer.refresh();
        }
    }

    private final class TreeContentProvider
    extends TreeContentProviderBase {
        private TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (parentElement instanceof FileProject) {
                FileProject fp = (FileProject)parentElement;
                return KernelModelElementUtils.getRootElements((EObject)fp, DSE.class).toArray();
            }
            if (parentElement instanceof DSE) {
                return null;
            }
            return null;
        }
    }
}

