/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.DashboardWizardRootElementSelectionBase;
import org.fortiss.af3.exploration.ui.perspective.dashboard.projectwizard.IDashboardWizardImportPage;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.EventChainsContainer;
import org.fortiss.af3.timing.model.EventConstraintsContainer;
import org.fortiss.af3.timing.model.ReactionConstraint;
import org.fortiss.af3.timing.model.SynchronizationConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class DashboardWizardSelectTimingSpecification
extends DashboardWizardRootElementSelectionBase<TimingSpecification> {
    public DashboardWizardSelectTimingSpecification() {
        super("Timing Specification", TimingSpecification.class);
    }

    @Override
    protected boolean isRelevantElement(EObject element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{ReactionConstraint.class, SynchronizationConstraint.class});
    }

    @Override
    protected boolean isRelevantRootElement(TimingSpecification ts) {
        TaskArchitecture referencedTAbyTS;
        List<IProjectRootElement> selectedElements = this.getDashboardWizard().getSelectedIProjectRootElements();
        TaskArchitecture selectedTA = (TaskArchitecture)EcoreUtils.pickFirstInstanceOf(TaskArchitecture.class, selectedElements);
        return selectedTA == (referencedTAbyTS = (TaskArchitecture)EcoreUtils.pickFirstInstanceOf(TaskArchitecture.class, (List)ts.getRootElements()));
    }

    @Override
    protected ITreeContentProvider createContentProvider() {
        return new TreeContentProviderBase(){

            public Object[] getChildren(Object element) {
                if (element instanceof List) {
                    return ((List)element).toArray();
                }
                if (element instanceof TimingSpecification) {
                    TimingSpecification ts = (TimingSpecification)element;
                    return new Object[]{ts.getEventChainsContainer(), ts.getConstraintsContainer()};
                }
                if (element instanceof EventChainsContainer) {
                    return ((EventChainsContainer)element).getEventChains().toArray();
                }
                if (element instanceof EventConstraintsContainer) {
                    return ((EventConstraintsContainer)element).getConstraints().toArray();
                }
                if (element instanceof EventChain) {
                    EventChain eventChain = (EventChain)element;
                    return Stream.concat(eventChain.getSubchains().stream(), eventChain.getConstraints().stream()).collect(Collectors.toList()).toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return ((EObject)element).eContainer();
            }
        };
    }

    @Override
    public IDashboardWizardImportPage.Converter<TimingSpecification> getModelToSnapShotConverter() {
        return new IDashboardWizardImportPage.Converter<TimingSpecification>(){

            @Override
            public ModelSnapshot apply(TimingSpecification t, Collection<ModelSnapshot> prevSnaps, Map<EObject, EObject> copyRefMap) {
                Optional<Object> ta2HwSet = Optional.empty();
                Optional ta2HwMS = LambdaUtils.getFirst(prevSnaps, s -> s.getSuperSet(TaskToExecutionUnitAllocationEntry.class) != null);
                if (ta2HwMS.isPresent()) {
                    ta2HwSet = Optional.of(((ModelSnapshot)ta2HwMS.get()).getSuperSet(TaskToExecutionUnitAllocationEntry.class));
                }
                SuperSet routeSet = ((ModelSnapshot)LambdaUtils.getFirst(prevSnaps, s -> s.getSuperSet(Route.class) != null).get()).getSuperSet(Route.class);
                Optional<Object> sig2RouteSet = Optional.empty();
                Optional sig2RouteMS = LambdaUtils.getFirst(prevSnaps, s -> s.getSuperSet(SignalToRouteAllocationEntry.class) != null);
                if (sig2RouteMS.isPresent()) {
                    sig2RouteSet = Optional.of(((ModelSnapshot)sig2RouteMS.get()).getSuperSet(SignalToRouteAllocationEntry.class));
                }
                SuperSet taskSet = ((ModelSnapshot)LambdaUtils.getFirst(prevSnaps, s -> s.getSuperSet(Task.class) != null).get()).getSuperSet(Task.class);
                return ModelSnapshotExtractUtils.createTimingSpecificationSnapshot(ta2HwSet, (SuperSet)taskSet, (SuperSet)routeSet, sig2RouteSet, (TimingSpecification)t);
            }
        };
    }

    @Override
    public boolean inputsAvailable(List<? extends IProjectRootElement> rootElements) {
        for (IProjectRootElement iProjectRootElement : rootElements) {
            if (!(iProjectRootElement instanceof TimingSpecification)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    protected boolean isSelectElements() {
        return false;
    }
}

