/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.generic;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.generic.DseSaveableView;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;

public abstract class DSEPerspectiveViewBase
extends DseSaveableView
implements IEventListener {
    protected final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite editableAreaComposite;
    private Label lblPerspectiveBaseView;
    private Button btnHelp;
    private static final Image HOME_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/home_icon.gif").createImage();
    private static final Image CONSTRAINTS_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/constraints_icon.png").createImage();
    private static final Image OBJECTIVES_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/objectives_icon.png").createImage();
    private static final Image SYNTHESIS_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/synthesis_icon.gif").createImage();
    private static final Image VISUALIZATION_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/visualization_icon.gif").createImage();
    private static final Image HELP_ICON = AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/help.png").createImage();

    @Override
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        Button btnBack = new Button(composite, 0);
        btnBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessManager.INSTANCE.backToLastProcessStep();
            }
        });
        btnBack.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.formToolkit.adapt((Control)btnBack, true, true);
        btnBack.setText("<- Back");
        this.lblPerspectiveBaseView = new Label(composite, 0);
        this.lblPerspectiveBaseView.setFont(SWTResourceManager.getFont((String)"Arial Black", (int)36, (int)1));
        this.lblPerspectiveBaseView.setText("DSE Perspective Base View");
        this.lblPerspectiveBaseView.setForeground(IProcessManager.INSTANCE.getColorForProcessStep(this.getProcessStep()));
        this.btnHelp = new Button(composite, 0);
        this.btnHelp.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnHelp, true, true);
        this.btnHelp.setText("Help");
        this.btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.HELP);
            }
        });
        this.editableAreaComposite = new Composite(parent, 0);
        EventBroker.getInstance().addListener(this);
    }

    public Composite getEditableAreaComposite() {
        return this.editableAreaComposite;
    }

    public void setHeaderText(String name) {
        this.lblPerspectiveBaseView.setText(name);
    }

    public Button getBtnHelp() {
        return this.btnHelp;
    }

    public abstract String helpButtonText();

    public abstract IProcessManager.EProcessStep getProcessStep();

    @Override
    public void dispose() {
        EventBroker.getInstance().removeListener(this);
        super.dispose();
    }

    @Override
    public void setFocus() {
        super.setFocus();
        switch (this.getProcessStep()) {
            case HOME: {
                this.setTitleImage(HOME_ICON);
                break;
            }
            case CONSTRAINTS: {
                this.setTitleImage(CONSTRAINTS_ICON);
                break;
            }
            case OBJECTIVES: {
                this.setTitleImage(OBJECTIVES_ICON);
                break;
            }
            case SYNTHESIS: {
                this.setTitleImage(SYNTHESIS_ICON);
                break;
            }
            case VISUALIZATION: {
                this.setTitleImage(VISUALIZATION_ICON);
                break;
            }
            case HELP: {
                this.setTitleImage(HELP_ICON);
            }
            default: {
                return;
            }
        }
    }
}

