/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.generic;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.generic.DSEPerspectiveViewBase;
import org.fortiss.af3.exploration.ui.perspective.generic.HelpComposite;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class HelpView
extends DSEPerspectiveViewBase {
    protected HelpComposite helpComposite;
    private IProcessManager.EProcessStep processHelp;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setHeaderText("DSE Help");
        Composite composite = this.getEditableAreaComposite();
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.helpComposite = new HelpComposite(composite, 0);
        this.helpComposite.setLayout((Layout)new GridLayout(1, false));
        this.helpComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.adapt((Composite)this.helpComposite);
        this.formToolkit.paintBordersFor((Composite)this.helpComposite);
        this.getBtnHelp().setEnabled(false);
    }

    public void setURL() {
        String helpPage = null;
        String headerText = null;
        switch (this.processHelp) {
            case HOME: {
                headerText = "DSE";
                helpPage = "dse_dashboard.html";
                break;
            }
            case CONSTRAINTS: {
                headerText = "Constraints";
                helpPage = "constraints.html";
                break;
            }
            case OBJECTIVES: {
                headerText = "Objectives";
                helpPage = "objectives.html";
                break;
            }
            case SYNTHESIS: {
                headerText = "Synthesis";
                helpPage = "synthesis.html";
                break;
            }
            case VISUALIZATION: {
                headerText = "Visualization";
                helpPage = "visualization.html";
            }
        }
        String pathToHtml = "html/dse/" + helpPage;
        if (helpPage != null) {
            this.setHeaderText(headerText + " Help");
            this.helpComposite.setURL(pathToHtml);
        } else {
            LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)("Online help not found for process step \"" + String.valueOf((Object)this.processHelp) + "\"."));
            this.helpComposite.setURL(null);
        }
    }

    public void setHelpFor(IProcessManager.EProcessStep processStep) {
        this.processHelp = processStep;
        this.setURL();
    }

    @Override
    public String helpButtonText() {
        return "Help";
    }

    @Override
    public IProcessManager.EProcessStep getProcessStep() {
        return IProcessManager.EProcessStep.HELP;
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT propId) {
    }
}

