/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.generic;

import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.TreeContextMenuItem;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class RemoveElementContextMenuItem
extends TreeContextMenuItem<INamedElement> {
    public RemoveElementContextMenuItem(INamedElement element) {
        super((Object)element, "Remove", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    protected EventHandler<ActionEvent> createOnActionHandler() {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                IDSEPerspectiveManager pm = IDSEPerspectiveManager.INSTANCE;
                INamedElement element = (INamedElement)RemoveElementContextMenuItem.this.getElement();
                if (element instanceof IExplorationTarget) {
                    pm.removeExplorationTarget((IExplorationTarget)element);
                } else if (element instanceof RuleSet) {
                    pm.removeRuleSet((RuleSet)element);
                } else if (element instanceof ExplorationStep) {
                    pm.removeExplorationStep((ExplorationStep)element);
                }
            }
        };
    }

    public boolean isHidden() {
        return this.getElement() == null || !ReflectionUtils.isInstanceOfAny((Object)this.getElement(), (Class[])new Class[]{IExplorationTarget.class, RuleSet.class, ExplorationStep.class});
    }

    public boolean isDisabled() {
        INamedElement element = (INamedElement)this.getElement();
        if (element == null) {
            return true;
        }
        Collection allReferences = EcoreUtils.getAllReferences((EObject)element);
        if (allReferences.isEmpty()) {
            return false;
        }
        return !(element instanceof ProcessStep) || !allReferences.stream().allMatch(r -> r instanceof DSE);
    }
}

