/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.generic;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.TreeContextMenuItem;
import org.fortiss.tooling.kernel.model.INamedElement;

public class SelectProcessStepContextMenuItem
extends TreeContextMenuItem<INamedElement> {
    public SelectProcessStepContextMenuItem(INamedElement element) {
        super((Object)element, "Select", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
    }

    protected EventHandler<ActionEvent> createOnActionHandler() {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                INamedElement element = (INamedElement)SelectProcessStepContextMenuItem.this.getElement();
                if (element instanceof ProcessStep) {
                    IDSEPerspectiveManager pm = IDSEPerspectiveManager.INSTANCE;
                    pm.setCurrentProcessStep((ProcessStep)element);
                }
            }
        };
    }

    public boolean isHidden() {
        return this.getElement() == null || !ReflectionUtils.isInstanceOfAny((Object)this.getElement(), (Class[])new Class[]{TargetDefinitionStep.class, SolutionSelectionStep.class, ExplorationStep.class});
    }

    public boolean isDisabled() {
        INamedElement element = (INamedElement)this.getElement();
        if (element == null) {
            return true;
        }
        IDSEPerspectiveManager pm = IDSEPerspectiveManager.INSTANCE;
        DSE dse = pm.getCurrentlySelectedDSE();
        if (dse == null) {
            return true;
        }
        return dse.getCurrentStep() == element;
    }
}

