/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.navigator;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.perspective.generic.DseSaveableView;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;

public class DSEProcessNavigator
extends DseSaveableView
implements IEventListener {
    private Button btnC;
    private MenuItem constraintMenu;
    private MenuItem objectiveMenu;
    private Button btnS;
    private Button btnV;
    public static final String ID = DSEProcessNavigator.class.getName();

    @Override
    public void createPartControl(Composite parent) {
        EventBroker.getInstance().addListener(this);
        DSE activeDSE = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        Button btnH = new Button(composite, 0);
        btnH.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        btnH.setImage(IProcessManager.INSTANCE.getImageForProcessStep(IProcessManager.EProcessStep.HOME));
        btnH.addSelectionListener((SelectionListener)new HomeSelectionAdapter());
        this.btnC = new Button(composite, 0);
        this.btnC.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnC.setImage(IProcessManager.INSTANCE.getImageForProcessStep(IProcessManager.EProcessStep.CONSTRAINTS));
        final Menu menu2 = new Menu((Control)this.btnC);
        this.btnC.setMenu(menu2);
        this.constraintMenu = new MenuItem(menu2, 0);
        this.constraintMenu.setText("Constraint Modeling");
        this.constraintMenu.addSelectionListener((SelectionListener)new ConstraintsSelectionAdapter());
        this.objectiveMenu = new MenuItem(menu2, 0);
        this.objectiveMenu.setText("Objective Modeling");
        this.objectiveMenu.addSelectionListener((SelectionListener)new ObjectivesSelectionAdapter());
        this.btnC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = DSEProcessNavigator.this.btnC.getBounds();
                Point point = DSEProcessNavigator.this.btnC.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                menu2.setLocation(point);
                menu2.setVisible(true);
            }
        });
        this.btnS = new Button(composite, 0);
        this.btnS.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnS.setImage(IProcessManager.INSTANCE.getImageForProcessStep(IProcessManager.EProcessStep.SYNTHESIS));
        this.btnS.addSelectionListener((SelectionListener)new SynthSelectionAdapter());
        this.btnV = new Button(composite, 0);
        this.btnV.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnV.setImage(IProcessManager.INSTANCE.getImageForProcessStep(IProcessManager.EProcessStep.VISUALIZATION));
        new Label(composite, 0);
        this.btnV.addSelectionListener((SelectionListener)new VisualizationSelectionAdapter());
        if (activeDSE == null) {
            this.enableViewButtons(false);
        }
        composite.update();
        composite.layout();
    }

    @Override
    public void dispose() {
        super.dispose();
        EventBroker.getInstance().removeListener(this);
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        if (event == IEventListener.DSE_EVENT.DSE_SELECTED_EVENT && source instanceof DSE) {
            this.enableViewButtons(true);
        } else if (event == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT) {
            this.enableViewButtons(false);
        }
    }

    private void enableViewButtons(boolean enable) {
        Display.getDefault().asyncExec(() -> {
            this.btnC.setEnabled(enable);
            this.constraintMenu.setEnabled(enable);
            this.objectiveMenu.setEnabled(enable);
            this.btnS.setEnabled(enable);
            this.btnV.setEnabled(enable);
        });
    }

    private class ConstraintsSelectionAdapter
    extends SelectionAdapter {
        private ConstraintsSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.CONSTRAINTS);
        }
    }

    private class HomeSelectionAdapter
    extends SelectionAdapter {
        private HomeSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.HOME);
        }
    }

    private class ObjectivesSelectionAdapter
    extends SelectionAdapter {
        private ObjectivesSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.OBJECTIVES);
        }
    }

    private class SynthSelectionAdapter
    extends SelectionAdapter {
        private SynthSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.SYNTHESIS);
        }
    }

    private class VisualizationSelectionAdapter
    extends SelectionAdapter {
        private VisualizationSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IProcessManager.INSTANCE.goToStep(IProcessManager.EProcessStep.VISUALIZATION);
        }
    }
}

