/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.navigator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.control.TreeView;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.ui.perspective.generic.RemoveElementContextMenuItem;
import org.fortiss.af3.exploration.ui.perspective.generic.SelectProcessStepContextMenuItem;
import org.fortiss.af3.exploration.ui.perspective.navigator.ReferencedExplorationConstraint;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.base.ui.javafx.control.treetableview.ModelElementTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeUIProviderBase;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ExplorationElementTreeViewer
extends ModelElementTreeViewer<INamedElement>
implements IEventListener {
    private Set<RuleSet> selectedRuleSets = new HashSet<RuleSet>();
    private Set<RuleSet> expandedRuleSets = new HashSet<RuleSet>();
    private Set<IExplorationConstraint<?>> unsatCores = new HashSet();

    public ExplorationElementTreeViewer(TreeView<INamedElement> treeView, INamedElement modelRoot, DynamicTreeContentProviderBase<INamedElement> contentProvider) {
        super(treeView, modelRoot, contentProvider);
        EventBroker.getInstance().addListener((IEventListener)this, true);
    }

    protected DynamicTreeUIProviderBase<INamedElement> createUIProvider() {
        return new ExplorationElementUIProvider();
    }

    @Override
    public void propertyChanged(Object src, IEventListener.DSE_EVENT event) {
        switch (event) {
            case RULE_SET_SELECTED: {
                this.selectedRuleSets.add((RuleSet)src);
                this.update();
                break;
            }
            case RULE_SET_DESELECTED: {
                this.selectedRuleSets.remove(src);
                this.update();
                break;
            }
            case UNSAT_CORES_UPDATE: {
                this.unsatCores.clear();
                this.unsatCores.addAll((Collection<IExplorationConstraint<?>>)((ExplorationSolution)src).getUnsatConstraints());
                this.update();
                break;
            }
            case PROCESS_STEP_SELECTED: {
                this.update();
            }
        }
    }

    protected class ExplorationElementUIProvider
    extends ModelElementTreeViewer.ModelElementUIProvider {
        public ExplorationElementUIProvider() {
            super((ModelElementTreeViewer)ExplorationElementTreeViewer.this);
            this.addContextMenuEntry(SelectProcessStepContextMenuItem.class);
            this.addContextMenuEntry(RemoveElementContextMenuItem.class);
        }

        public String getCellStyle(INamedElement element) {
            IDSEPerspectiveManager pm;
            if (element instanceof RuleSet) {
                RuleSet ruleSet = (RuleSet)element;
                if (ExplorationElementTreeViewer.this.expandedRuleSets.contains(ruleSet)) {
                    ExplorationElementTreeViewer.this.collapseItem((INamedElement)ruleSet);
                    ExplorationElementTreeViewer.this.expandedRuleSets.remove(ruleSet);
                }
                HashSet expTargets = new HashSet();
                expTargets.addAll(ruleSet.getExplorationTargets());
                expTargets.retainAll(ExplorationElementTreeViewer.this.unsatCores);
                for (IExplorationTarget tgt : expTargets) {
                    ReferencedExplorationConstraint referencedExplorationConstraint = new ReferencedExplorationConstraint((IExplorationConstraint)tgt);
                    if (ExplorationElementTreeViewer.this.findItem((INamedElement)referencedExplorationConstraint) == null) continue;
                    ExplorationElementTreeViewer.this.expandItem((INamedElement)referencedExplorationConstraint);
                    ExplorationElementTreeViewer.this.expandedRuleSets.add(ruleSet);
                }
                if (ExplorationElementTreeViewer.this.selectedRuleSets.contains(ruleSet)) {
                    return "-fx-background-color: #87CEFA;";
                }
            } else if (element instanceof ReferencedExplorationConstraint) {
                IExplorationConstraint<?> constraint = ((ReferencedExplorationConstraint)element).getConstraint();
                if (ExplorationElementTreeViewer.this.unsatCores.contains(constraint)) {
                    return "-fx-background-color: #FFFF00;";
                }
            } else if (element instanceof ProcessStep && (pm = IDSEPerspectiveManager.INSTANCE).getCurrentlySelectedDSE().getCurrentStep() == element) {
                return "-fx-background-color: #13a634;";
            }
            return super.getCellStyle((Object)element);
        }
    }
}

