/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.navigator;

import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TreeView;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.ui.perspective.navigator.ExplorationElementTreeViewer;
import org.fortiss.af3.exploration.ui.perspective.navigator.ExplorationNavigatorElementContentProvider;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.base.ui.javafx.control.treetableview.ModelElementTreeViewer;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ExplorationNavigatorFXController
extends CompositeFXControllerBase<TreeView<INamedElement>, Node>
implements IEventListener {
    @FXML
    private TreeView<INamedElement> treeView;
    private ModelElementTreeViewer<INamedElement> elemViewer;
    private ExplorationNavigatorElementContentProvider contentProvider;

    public ExplorationNavigatorFXController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "ExplorationNavigatorLayout.fxml";
    }

    public void initialize() {
        this.contentProvider = new ExplorationNavigatorElementContentProvider();
        IDSEPerspectiveManager pm = IDSEPerspectiveManager.INSTANCE;
        this.elemViewer = new ExplorationElementTreeViewer(this.treeView, (INamedElement)pm.getCurrentlySelectedDSE(), this.contentProvider);
        EventBroker.getInstance().addListener((IEventListener)this, true);
    }

    @Override
    public void propertyChanged(Object src, IEventListener.DSE_EVENT event) {
        switch (event) {
            case DSE_SELECTED_EVENT: {
                this.elemViewer = new ExplorationElementTreeViewer(this.treeView, (INamedElement)((DSE)src), this.contentProvider);
                this.elemViewer.expandItem((INamedElement)((DSE)src).getCurrentStep());
                break;
            }
            case DSE_REMOVED_EVENT: {
                Platform.runLater(() -> this.treeView.setRoot(null));
                break;
            }
            case EXP_TARGET_ADDED: {
                this.elemViewer.update();
                this.elemViewer.expandItem((INamedElement)((IExplorationTarget)src));
                break;
            }
            case RULE_SET_ADDED: 
            case RULE_SET_CHANGED: {
                this.elemViewer.update();
                this.elemViewer.expandItem((INamedElement)((RuleSet)src));
                break;
            }
            case EXP_TARGET_REMOVED: 
            case RULE_SET_REMOVED: {
                this.elemViewer.update();
                break;
            }
            case PROCESS_STEP_ADDED: {
                this.elemViewer.update();
                this.elemViewer.expandItem((INamedElement)((ProcessStep)src));
                break;
            }
            case PROCESS_STEP_REMOVED: {
                this.elemViewer.update();
                this.treeView.refresh();
            }
        }
    }
}

