/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.process;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.dashboard.DashboardFXViewPart;
import org.fortiss.af3.exploration.ui.perspective.generic.HelpView;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.synthesis.SynthesisFXViewPart;
import org.fortiss.af3.exploration.ui.perspective.targetdef.constraint.ConstraintsFXViewPart;
import org.fortiss.af3.exploration.ui.perspective.targetdef.objective.ObjectivesFXViewPart;
import org.fortiss.af3.exploration.ui.perspective.visualization.VisualizationViewBackend;
import org.fortiss.af3.exploration.ui.util.ExplorationUiUtils;

public class ProcessManager
implements IProcessManager {
    private LinkedList<IProcessManager.EProcessStep> stack;
    private Map<IProcessManager.EProcessStep, String> viewRegistry = new HashMap<IProcessManager.EProcessStep, String>();

    ProcessManager() {
        this.stack = new LinkedList();
        this.stack.push(IProcessManager.EProcessStep.HOME);
        this.viewRegistry.put(IProcessManager.EProcessStep.HOME, ExplorationUiUtils.getFQNID(DashboardFXViewPart.class));
        this.viewRegistry.put(IProcessManager.EProcessStep.CONSTRAINTS, ExplorationUiUtils.getFQNID(ConstraintsFXViewPart.class));
        this.viewRegistry.put(IProcessManager.EProcessStep.OBJECTIVES, ExplorationUiUtils.getFQNID(ObjectivesFXViewPart.class));
        this.viewRegistry.put(IProcessManager.EProcessStep.SYNTHESIS, ExplorationUiUtils.getFQNID(SynthesisFXViewPart.class));
        this.viewRegistry.put(IProcessManager.EProcessStep.VISUALIZATION, ExplorationUiUtils.getFQNID(VisualizationViewBackend.class));
        this.viewRegistry.put(IProcessManager.EProcessStep.HELP, ExplorationUiUtils.getFQNID(HelpView.class));
    }

    @Override
    public void goToStep(IProcessManager.EProcessStep step) {
        if (step != this.stack.peek()) {
            this.hideLastView();
            this.stack.push(step);
        }
        if (step == IProcessManager.EProcessStep.HELP) {
            step = this.stack.get(1);
            this.showHelpView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.HELP), step);
        } else {
            this.showView(this.viewRegistry.get((Object)step));
        }
    }

    private void showView(String viewID) {
        try {
            WorkbenchUtils.getActiveWorkbenchPage().showView(viewID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void showHelpView(String viewID, IProcessManager.EProcessStep processStep) {
        try {
            HelpView showView = (HelpView)WorkbenchUtils.getActiveWorkbenchPage().showView(viewID);
            showView.setHelpFor(processStep);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void backToLastProcessStep() {
        if (this.stack.size() == 1) {
            return;
        }
        this.hideLastView();
        this.stack.pop();
        IProcessManager.EProcessStep prevStep = this.stack.pop();
        this.goToStep(prevStep);
    }

    private void hideLastView() {
        if (!this.stack.isEmpty()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            IViewPart viewToClose = null;
            switch (this.stack.get(0)) {
                case HOME: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.HOME));
                    break;
                }
                case HELP: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.HELP));
                    break;
                }
                case CONSTRAINTS: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.CONSTRAINTS));
                    break;
                }
                case OBJECTIVES: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.OBJECTIVES));
                    break;
                }
                case SYNTHESIS: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.SYNTHESIS));
                    break;
                }
                case VISUALIZATION: {
                    viewToClose = activePage.findView(this.viewRegistry.get((Object)IProcessManager.EProcessStep.VISUALIZATION));
                }
            }
            if (viewToClose != null) {
                activePage.hideView(viewToClose);
            }
        }
    }

    @Override
    public Image getImageForProcessStep(IProcessManager.EProcessStep processStep) {
        switch (processStep) {
            case HOME: {
                return AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/home.png").createImage();
            }
            case HELP: {
                return null;
            }
            case CONSTRAINTS: 
            case OBJECTIVES: {
                return AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/constraints.png").createImage();
            }
            case SYNTHESIS: {
                return AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/synthesis.png").createImage();
            }
            case VISUALIZATION: {
                return AF3ExplorationUIActivator.getImageDescriptor("res/org/fortiss/af3/exploration/ui/icons/visualization.png").createImage();
            }
        }
        return null;
    }

    @Override
    public Color getColorForProcessStep(IProcessManager.EProcessStep processStep) {
        Color homeColor = SWTResourceManager.getColor((int)157, (int)4, (int)0);
        Color constraintsColor = SWTResourceManager.getColor((int)0, (int)0, (int)0);
        Color synthesisColor = SWTResourceManager.getColor((int)0, (int)61, (int)180);
        Color visColor = SWTResourceManager.getColor((int)28, (int)120, (int)8);
        Color helpColor = SWTResourceManager.getColor((int)205, (int)149, (int)12);
        switch (processStep) {
            case HOME: {
                return homeColor;
            }
            case HELP: {
                return helpColor;
            }
            case CONSTRAINTS: {
                return constraintsColor;
            }
            case OBJECTIVES: {
                return constraintsColor;
            }
            case SYNTHESIS: {
                return synthesisColor;
            }
            case VISUALIZATION: {
                return visColor;
            }
        }
        return null;
    }

    @Override
    public IProcessManager.EProcessStep getCurrentProcessStep() {
        return this.stack.getFirst();
    }

    @Override
    public List<String> getAllRegisteredViewIDs() {
        List<String> collect = this.viewRegistry.entrySet().stream().map(v -> (String)v.getValue()).collect(Collectors.toList());
        return collect;
    }
}

