/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;

public class EventBroker {
    private Map<IEventListener, String> listeners = new LinkedHashMap<IEventListener, String>();
    private static EventBroker INSTANCE;

    public static synchronized EventBroker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventBroker();
        }
        return INSTANCE;
    }

    private EventBroker() {
    }

    private void addListener(IEventListener listener, boolean singletonRegistration, String uniqueToken) {
        String value;
        if (singletonRegistration) {
            Class<?> clazz = listener.getClass();
            value = clazz.getCanonicalName() + (uniqueToken != null ? uniqueToken : "");
            this.listeners.keySet().removeIf(l -> {
                String x = this.listeners.get(l);
                return value.equals(x);
            });
        } else {
            value = null;
        }
        this.listeners.put(listener, value);
    }

    public void addListener(IEventListener listener, String uniqueToken) {
        this.addListener(listener, true, uniqueToken);
    }

    public void addListener(IEventListener listener, boolean singletonRegistration) {
        this.addListener(listener, singletonRegistration, null);
    }

    public void addListener(IEventListener listener) {
        this.addListener(listener, false);
    }

    public void removeListener(IEventListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyChanged(Object source, IEventListener.DSE_EVENT event) {
        for (IEventListener listener : new ArrayList<IEventListener>(this.listeners.keySet())) {
            listener.propertyChanged(source, event);
        }
    }
}

