/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.service.internal.ExplorationCommandRunner;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.listener.IPersistencyServiceListener;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class DSEPerspectiveManager
implements IDSEPerspectiveManager {
    private EventBroker evBroker = EventBroker.getInstance();
    private DSE currentDSE;
    private List<IExplorationConstraint<?>> latestFailedConstraints = Collections.emptyList();
    private List<RuleSet> latestUsedSubSets = Collections.emptyList();

    public DSEPerspectiveManager() {
        IPersistencyService.getInstance().addTopLevelElementListener((IPersistencyServiceListener)new DSENodeListener());
    }

    @Override
    public DSE getCurrentlySelectedDSE() {
        return this.currentDSE;
    }

    @Override
    public void setCurrentlySelectedDSE(DSE dse) {
        this.currentDSE = dse;
        this.evBroker.firePropertyChanged(dse, IEventListener.DSE_EVENT.DSE_SELECTED_EVENT);
        FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)dse, FileProject.class, (boolean)false);
        fp.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getEventType() != 4) {
                    return;
                }
                if (notification.getOldValue() == DSEPerspectiveManager.this.currentDSE && notification.getNewValue() == null) {
                    DSEPerspectiveManager.this.currentDSE = null;
                    DSEPerspectiveManager.this.evBroker.firePropertyChanged(null, IEventListener.DSE_EVENT.DSE_REMOVED_EVENT);
                }
            }
        });
    }

    @Override
    public void setCurrentProcessStep(ProcessStep element) {
        DSE dse = this.getCurrentlySelectedDSE();
        ExplorationCommandRunner.getRunner().run(() -> dse.setCurrentStep(element));
        this.evBroker.firePropertyChanged(element, IEventListener.DSE_EVENT.PROCESS_STEP_SELECTED);
    }

    @Override
    public void removeRuleSet(RuleSet ruleSet) {
        ExplorationCommandRunner.getRunner().run(() -> EcoreUtil.delete((EObject)ruleSet));
        this.latestUsedSubSets.remove(ruleSet);
        this.evBroker.firePropertyChanged(ruleSet, IEventListener.DSE_EVENT.RULE_SET_REMOVED);
    }

    @Override
    public void removeExplorationTarget(IExplorationTarget<?> target) {
        ExplorationCommandRunner.getRunner().run(() -> EcoreUtil.delete((EObject)target));
        this.evBroker.firePropertyChanged(target, IEventListener.DSE_EVENT.EXP_TARGET_REMOVED);
    }

    @Override
    public void removeExplorationStep(ExplorationStep explorationStep) {
        ExplorationCommandRunner.getRunner().run(() -> {
            this.currentDSE.setCurrentStep(explorationStep.getParent());
            EcoreUtil.delete((EObject)explorationStep);
        });
        this.evBroker.firePropertyChanged(explorationStep, IEventListener.DSE_EVENT.PROCESS_STEP_REMOVED);
    }

    @Override
    public void addExplorationTarget(IExplorationTarget<?> expTarget) {
        DSE dse = this.getCurrentlySelectedDSE();
        UniqueIDUtils.prepareUniqueID(expTarget, (EObject)dse);
        if (!(this.currentDSE.getCurrentStep() instanceof TargetDefinitionStep)) {
            TargetDefinitionStep tgtStep = DSEProjectModelElementFactory.createTargetDefinitionStep((String)"Target Definition");
            UniqueIDUtils.prepareUniqueID((EObject)tgtStep, (EObject)dse);
            ExplorationCommandRunner.getRunner().run(() -> dse.addProcessStep((ProcessStep)tgtStep));
            this.evBroker.firePropertyChanged(tgtStep, IEventListener.DSE_EVENT.PROCESS_STEP_ADDED);
        }
        ExplorationCommandRunner.getRunner().run(() -> {
            boolean bl = ((TargetDefinitionStep)this.currentDSE.getCurrentStep()).getDefinedTargets().add((Object)expTarget);
        });
        this.evBroker.firePropertyChanged(expTarget, IEventListener.DSE_EVENT.EXP_TARGET_ADDED);
    }

    @Override
    public void addExplorationSubSet(RuleSet subSet) {
        Optional first;
        if (subSet.getExplorationTargets().isEmpty()) {
            return;
        }
        ProcessStep currentStep = this.currentDSE.getCurrentStep();
        if (!(currentStep instanceof TargetDefinitionStep)) {
            throw new RuntimeException("Wrong ProcessStep type. Can not add RuleSet to " + currentStep.getClass().getSimpleName());
        }
        TargetDefinitionStep currTgtDefStep = (TargetDefinitionStep)currentStep;
        if (subSet.isImplicit() && (first = LambdaUtils.getFirst((Collection)LambdaUtils.filter((Collection)currTgtDefStep.getRuleSets(), s -> s.isImplicit()))).isPresent()) {
            RuleSet eSSS = (RuleSet)first.get();
            eSSS.getExplorationTargets().clear();
            eSSS.getExplorationTargets().addAll((Collection)subSet.getExplorationTargets());
            return;
        }
        ExplorationCommandRunner.getRunner().run(() -> {
            boolean bl = currTgtDefStep.getDefinedRuleSets().add((Object)subSet);
        });
        this.evBroker.firePropertyChanged(subSet, IEventListener.DSE_EVENT.RULE_SET_ADDED);
    }

    @Override
    public void addExplorationSubSet(DSE dse, ArrayList<RuleSet> allConstraintsSets) {
        ProcessStep processStep = dse.getCurrentStep();
        if (!(processStep instanceof TargetDefinitionStep)) {
            if (processStep.getParent() instanceof TargetDefinitionStep) {
                TargetDefinitionStep targetDefinitionStep = (TargetDefinitionStep)processStep.getParent();
                ExplorationCommandRunner.getRunner().run(() -> dse.setCurrentStep((ProcessStep)targetDefinitionStep));
            } else {
                TargetDefinitionStep targetDefinitionStep = DSEProjectModelElementFactory.createTargetDefinitionStep((String)"Target Definition");
                UniqueIDUtils.prepareUniqueID((EObject)targetDefinitionStep, (EObject)dse);
                ExplorationCommandRunner.getRunner().run(() -> dse.addProcessStep((ProcessStep)targetDefinitionStep));
                EventBroker.getInstance().firePropertyChanged(targetDefinitionStep, IEventListener.DSE_EVENT.PROCESS_STEP_ADDED);
            }
        }
        allConstraintsSets.stream().forEach(s -> {
            UniqueIDUtils.prepareUniqueID((EObject)s, (EObject)dse);
            ExplorationCommandRunner.getRunner().run(() -> this.addExplorationSubSet((RuleSet)s));
        });
    }

    @Override
    public void setLatestFailedConstraints(List<IExplorationConstraint<?>> constraints) {
        this.latestFailedConstraints = constraints;
        this.evBroker.firePropertyChanged(this.latestFailedConstraints, IEventListener.DSE_EVENT.UNSAT_CORES_UPDATE);
    }

    @Override
    public List<IExplorationConstraint<?>> getLatestFailedConstraints() {
        return this.latestFailedConstraints;
    }

    @Override
    public void setLatestCheckedSubsets(List<RuleSet> subSets) {
        this.latestUsedSubSets = subSets;
    }

    @Override
    public List<RuleSet> getLatestCheckedSubsets() {
        return this.latestUsedSubSets;
    }

    private class DSENodeListener
    implements IPersistencyServiceListener {
        private DSENodeListener() {
        }

        public void topLevelElementLoaded(ITopLevelElement element) {
        }

        public void topLevelElementAdded(ITopLevelElement element) {
        }

        public void topLevelElementContentChanged(ITopLevelElement element) {
        }

        public void topLevelElementRemoved(ITopLevelElement element) {
            List dseNodes = KernelModelElementUtils.getRootElements((EObject)element.getRootModelElement(), DSE.class);
            if (dseNodes.contains(DSEPerspectiveManager.this.currentDSE)) {
                DSEPerspectiveManager.this.currentDSE = null;
                DSEPerspectiveManager.this.evBroker.firePropertyChanged(null, IEventListener.DSE_EVENT.DSE_REMOVED_EVENT);
            }
        }
    }
}

