/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEUIPatternExtensionService;
import org.fortiss.af3.exploration.ui.perspective.targetdef.IPatternFXController;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class DSEUIPatternExtensionService
implements IDSEUIPatternExtensionService,
IIntrospectiveKernelService {
    private List<IPatternFXController> registeredConstraintPatterns = new ArrayList<IPatternFXController>();
    private List<IPatternFXController> registeredObjectivePatterns = new ArrayList<IPatternFXController>();
    private static IDSEUIPatternExtensionService INSTANCE;
    private static final String EXTENSION_POINT_NAME = "org.fortiss.af3.exploration.ui.dseUIPattern";
    private static final String OBJECTIVE_CONFIGURATION_ELEMENT_NAME = "objectivePattern";
    private static final String CONSTRAINT_CONFIGURATION_ELEMENT_NAME = "constraintPattern";
    private static final String ATTRIBUTE_NAME = "patternController";

    private DSEUIPatternExtensionService() {
    }

    public static synchronized IDSEUIPatternExtensionService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DSEUIPatternExtensionService();
        }
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public void initializeService() {
        IPatternFXController controller;
        Class handlerClass;
        Bundle bundle;
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements((String)EXTENSION_POINT_NAME, (String)OBJECTIVE_CONFIGURATION_ELEMENT_NAME)) {
            bundle = ExtensionPointUtils.getBundle((IConfigurationElement)ce);
            try {
                handlerClass = ExtensionPointUtils.loadClass((String)ce.getAttribute(ATTRIBUTE_NAME), (Bundle)bundle);
                controller = (IPatternFXController)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.registeredObjectivePatterns.add(controller);
            }
            catch (Exception ex) {
                LoggingUtils.error((Plugin)ToolingKernelActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
            }
        }
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements((String)EXTENSION_POINT_NAME, (String)CONSTRAINT_CONFIGURATION_ELEMENT_NAME)) {
            bundle = ExtensionPointUtils.getBundle((IConfigurationElement)ce);
            try {
                handlerClass = ExtensionPointUtils.loadClass((String)ce.getAttribute(ATTRIBUTE_NAME), (Bundle)bundle);
                controller = (IPatternFXController)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.registeredConstraintPatterns.add(controller);
            }
            catch (Exception ex) {
                LoggingUtils.error((Plugin)ToolingKernelActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public List<IPatternFXController> getConstraintPatterns() {
        return this.registeredConstraintPatterns;
    }

    @Override
    public List<IPatternFXController> getObjectivePatterns() {
        return this.registeredObjectivePatterns;
    }

    public String getIntrospectionLabel() {
        return "External DSE Extension Service";
    }

    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThe service is used to add external Design Space Exploration (DSE) patterns.";
    }
}

