/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.service.internal;

import java.io.IOException;
import org.conqat.ide.commons.ui.logging.LoggingUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.Saveable;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public final class SaveableWrapper
implements IEventListener {
    private TopLevelElementSaveable currentSaveable;
    private static SaveableWrapper instance;

    public static synchronized SaveableWrapper getInstance() {
        if (instance == null) {
            instance = new SaveableWrapper();
        }
        return instance;
    }

    private SaveableWrapper() {
        EventBroker.getInstance().addListener(this);
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT propId) {
        if (propId == IEventListener.DSE_EVENT.DSE_SELECTED_EVENT && source instanceof DSE) {
            ITopLevelElement topLevelElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)((DSE)source));
            this.setSaveable(topLevelElement);
        } else if (propId == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT) {
            this.currentSaveable = null;
        }
    }

    public boolean isDirty() {
        return this.currentSaveable != null ? this.currentSaveable.topLevelElement.isDirty() : false;
    }

    public Saveable getSaveable() {
        return this.currentSaveable;
    }

    private void setSaveable(ITopLevelElement saveableTopLevelElement) {
        this.currentSaveable = new TopLevelElementSaveable(saveableTopLevelElement);
    }

    private class TopLevelElementSaveable
    extends Saveable {
        private final ITopLevelElement topLevelElement;

        public TopLevelElementSaveable(ITopLevelElement topLevelElement) {
            this.topLevelElement = topLevelElement;
        }

        public String getName() {
            return this.topLevelElement.getSaveableName();
        }

        public String getToolTipText() {
            return "";
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            try {
                this.topLevelElement.doSave(monitor);
            }
            catch (IOException e) {
                LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)("Error during save of " + this.getName()), (Throwable)e);
            }
        }

        public boolean isDirty() {
            return this.topLevelElement.isDirty();
        }

        public boolean equals(Object object) {
            boolean b = object instanceof TopLevelElementSaveable;
            return b && ((TopLevelElementSaveable)((Object)object)).topLevelElement == this.topLevelElement;
        }

        public int hashCode() {
            return this.topLevelElement.hashCode();
        }
    }
}

