/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.text.SimpleDateFormat;
import java.util.Collections;
import javafx.scene.control.ContextMenu;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.ui.perspective.generic.RemoveElementContextMenuItem;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.service.internal.ExplorationCommandRunner;
import org.fortiss.tooling.base.ui.javafx.control.treetableview.DynamicTreeTableNameProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.TreeContextMenuItem;
import org.fortiss.tooling.kernel.model.INamedElement;

public class RuleSetUIProvider
extends DynamicTreeTableNameProvider<RuleSet> {
    protected final EventBroker evBroker = EventBroker.getInstance();

    public String getLabel(RuleSet element, int column) {
        String retString = super.getLabel((INamedElement)element, column);
        switch (column) {
            case 1: {
                retString = element.getAuthor();
                break;
            }
            case 2: {
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                retString = formatter.format(element.getDate());
            }
        }
        return retString;
    }

    public boolean isEditable(int column) {
        return column == 0 || column == 1;
    }

    public void updateValue(RuleSet element, int column, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        switch (column) {
            case 0: {
                ExplorationCommandRunner.getRunner().run(() -> element.setName((String)value));
                break;
            }
            case 1: {
                ExplorationCommandRunner.getRunner().run(() -> element.setAuthor((String)value));
            }
        }
        this.evBroker.firePropertyChanged(element, IEventListener.DSE_EVENT.RULE_SET_CHANGED);
    }

    public ContextMenu createContextMenu(RuleSet element, int column) {
        return TreeContextMenuItem.createTreeContextMenu(Collections.singletonList(RemoveElementContextMenuItem.class), (Object)element);
    }
}

