/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.TreeTableView;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.model.BackendSetting;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.TerminationCriteria;
import org.fortiss.af3.exploration.ui.perspective.service.internal.ExplorationCommandRunner;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.model.INamedElement;

public class SolverSettingsTreeTableViewer {
    protected DynamicTreeTableViewer<?> dynTreeTableViewer;

    public SolverSettingsTreeTableViewer(TreeTableView<Object> treeView, SolverSettings settingsMap) {
        SettingsUIProvider uiProvider = new SettingsUIProvider();
        this.dynTreeTableViewer = new DynamicTreeTableViewer(treeView, (Object)settingsMap, false, 0, (DynamicTreeContentProviderBase)new SettingsContentProvider(), (DynamicTreeTableUIProviderBase)uiProvider);
        this.dynTreeTableViewer.addColumn("Setting", 200);
        this.dynTreeTableViewer.addColumn("Value", 150);
    }

    public void update() {
        this.dynTreeTableViewer.update();
    }

    protected class SettingsContentProvider
    extends DynamicTreeContentProviderBase<Object> {
        protected SettingsContentProvider() {
        }

        protected Collection<?> getChildren(Object parent) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parent instanceof SolverSettings) {
                SolverSettings settings = (SolverSettings)parent;
                children.add(settings.getTermination());
                children.add(settings.getBackendSettings());
            } else if (parent instanceof TerminationCriteria) {
                TerminationCriteria term = (TerminationCriteria)parent;
                children.add(term.getTimeoutS());
                children.add(term.getIterations());
            } else if (parent instanceof EList) {
                EList bSettings = (EList)parent;
                children.addAll((Collection<Object>)bSettings);
            }
            return children;
        }
    }

    protected class SettingsUIProvider
    extends DynamicTreeTableUIProviderBase<Object> {
        protected SettingsUIProvider() {
        }

        public String getLabel(Object element, int column) {
            switch (column) {
                case 0: {
                    if (element instanceof INamedElement) {
                        return ((INamedElement)element).getName();
                    }
                    if (!(element instanceof EList)) break;
                    return "Backend-specific";
                }
                case 1: {
                    if (!(element instanceof BackendSetting)) break;
                    return ((BackendSetting)element).getValue().toString();
                }
            }
            return null;
        }

        public void updateValue(Object element, int column, Object value) {
            switch (column) {
                case 1: {
                    if (!(element instanceof BackendSetting) || !(value instanceof String)) break;
                    BackendSetting setting = (BackendSetting)element;
                    if (Number.class.isAssignableFrom(setting.getType())) {
                        ExplorationCommandRunner.getRunner().run(() -> setting.setValue((Object)NumberUtils.createNumber((String)((String)value))));
                        break;
                    }
                    if (Boolean.class.isAssignableFrom(setting.getType())) {
                        ExplorationCommandRunner.getRunner().run(() -> setting.setValue((Object)Boolean.getBoolean((String)value)));
                        break;
                    }
                    if (!String.class.isAssignableFrom(setting.getType())) break;
                    ExplorationCommandRunner.getRunner().run(() -> setting.setValue(value));
                }
            }
        }

        public boolean isEditable(int column) {
            return column == 1;
        }

        public Node getIconNode(Object element, int column) {
            return null;
        }
    }
}

