/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicStreamContentProvider;

public class SynthesisCategoryExplorationTargetContentProvider<T extends IExplorationTarget<?>>
extends DynamicStreamContentProvider<T, Supplier<Stream<T>>>
implements IEventListener {
    protected Set<Class<? extends ISynthesisCategory>> synthCategories = new HashSet<Class<? extends ISynthesisCategory>>();

    public SynthesisCategoryExplorationTargetContentProvider(Class<?> targetType) {
        EventBroker.getInstance().addListener((IEventListener)this, targetType.getCanonicalName());
    }

    protected boolean filter(T element, String filterValue) {
        if (element == null) {
            return false;
        }
        return this.synthCategories.containsAll((Collection<?>)element.getSynthesisCategories());
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        switch (event) {
            case SYNTH_CAT_ADDED: {
                List added = (List)source;
                added.forEach(sC -> {
                    boolean bl = this.synthCategories.add((Class<? extends ISynthesisCategory>)sC);
                });
                break;
            }
            case SYNTH_CAT_REMOVED: {
                List removed = (List)source;
                removed.forEach(sC -> {
                    boolean bl = this.synthCategories.remove(sC);
                });
            }
        }
    }
}

