/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicStreamContentProvider;

public class SynthesisCategoryRuleSetContentProvider
extends DynamicStreamContentProvider<RuleSet, Supplier<Stream<RuleSet>>>
implements IEventListener {
    protected Collection<Class<? extends ISynthesisCategory>> synthCategories = new HashSet<Class<? extends ISynthesisCategory>>();

    public SynthesisCategoryRuleSetContentProvider(Class<?> targetType) {
        EventBroker.getInstance().addListener((IEventListener)this, targetType.getCanonicalName());
    }

    protected boolean filter(RuleSet element, String filterValue) {
        Collection rsCategories = element.getExplorationTargets().stream().flatMap(c -> c.getSynthesisCategories().stream()).collect(Collectors.toList());
        return this.synthCategories.containsAll(rsCategories);
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        switch (event) {
            case SYNTH_CAT_ADDED: {
                List added = (List)source;
                added.forEach(sC -> {
                    boolean bl = this.synthCategories.add((Class<? extends ISynthesisCategory>)sC);
                });
                break;
            }
            case SYNTH_CAT_REMOVED: {
                List removed = (List)source;
                removed.forEach(sC -> {
                    boolean bl = this.synthCategories.remove(sC);
                });
            }
        }
    }
}

