/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.AnchorPane;
import javafx.util.StringConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionState;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.DSEJobAdapter;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.ui.perspective.generic.RemoveElementContextMenuItem;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.service.internal.ExplorationCommandRunner;
import org.fortiss.af3.exploration.ui.perspective.synthesis.RuleSetUIProvider;
import org.fortiss.af3.exploration.ui.perspective.synthesis.SolverSettingsDialog;
import org.fortiss.af3.exploration.ui.perspective.synthesis.SynthesisCategoryExplorationTargetContentProvider;
import org.fortiss.af3.exploration.ui.perspective.synthesis.SynthesisCategoryRuleSetContentProvider;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.base.ui.javafx.control.treetableview.DynamicTreeTableNameProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicStreamContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.TreeContextMenuItem;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class SynthesisFXContentController
extends CompositeFXControllerBase<AnchorPane, Node>
implements IEventListener {
    private Set<Class<? extends ISynthesisCategory>> selectedSynthesises = new HashSet<Class<? extends ISynthesisCategory>>();
    protected final EventBroker evBroker = EventBroker.getInstance();
    protected final IDSEBackendService dbsService = IDSEBackendService.getInstance();
    @FXML
    private TreeTableView<IExplorationConstraint<?>> constraintTbl;
    private DynamicTreeTableViewer<IExplorationConstraint<?>> constraintView;
    @FXML
    private TreeTableView<RuleSet> constraintRuleSetTbl;
    private DynamicTreeTableViewer<RuleSet> constraintRuleSetView;
    @FXML
    private Button createConstraintRuleSetBtn;
    @FXML
    private Button addConstraintRuleSetBtn;
    @FXML
    private Button removeConstraintRuleSetBtn;
    @FXML
    private TreeTableView<IExplorationObjective<?>> objectiveTbl;
    private DynamicTreeTableViewer<IExplorationObjective<?>> objectiveView;
    @FXML
    private TreeTableView<RuleSet> objectiveRuleSetTbl;
    private DynamicTreeTableViewer<RuleSet> objectiveRuleSetView;
    @FXML
    private Button createObjectiveRuleSetBtn;
    @FXML
    private Button addObjectiveRuleSetBtn;
    @FXML
    private Button removeObjectiveRuleSetBtn;
    @FXML
    private ComboBox<IDSEBackend> feasibilitySolverCombo;
    @FXML
    private ComboBox<IDSEBackend> optimalitySolverCombo;
    protected final ExplorationCommandRunner runner = ExplorationCommandRunner.getRunner();
    protected Collection<IExplorationTarget<?>> availTargets;
    protected Collection<RuleSet> availRuleSets;
    private List<RuleSet> selectedRuleSets = new ArrayList<RuleSet>();
    protected Map<Class<? extends IDSEBackend>, SolverSettings> solverSettings = new HashMap<Class<? extends IDSEBackend>, SolverSettings>();
    protected boolean useResults = false;
    private static int cstrRsCnt = 0;
    private static int objRsCnt = 0;

    public SynthesisFXContentController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "SynthesisContentLayout.fxml";
    }

    private DSE getActiveDse() {
        return IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
    }

    public void initialize() {
        if (this.getActiveDse() != null) {
            this.updateTargetRuleSetLists();
            this.populateTargetRuleSetTables();
            this.populateSolverCombos();
            this.loadSolverSettings();
        }
    }

    private void updateTargetRuleSetLists() {
        this.availTargets = this.getActiveDse().getCurrentStep().getUserDefinedTargets();
        this.availRuleSets = this.getActiveDse().getCurrentStep().getRuleSets();
    }

    protected void populateTargetRuleSetTables() {
        this.constraintView = this.setupExplorationTargetListings(this.constraintTbl, IExplorationConstraint.class);
        this.objectiveView = this.setupExplorationTargetListings(this.objectiveTbl, IExplorationObjective.class);
        this.constraintRuleSetView = this.setupRuleSetListings(this.constraintRuleSetTbl, IExplorationConstraint.class);
        this.objectiveRuleSetView = this.setupRuleSetListings(this.objectiveRuleSetTbl, IExplorationObjective.class);
        String expTgtPlaceHolderStr = "No objectives / constraints defined for the selected synthesis types.";
        String ruleSetPlaceHolderStr = "No rule sets defined for the selected synthesis types.";
        this.constraintTbl.setPlaceholder((Node)new Label(expTgtPlaceHolderStr));
        this.objectiveTbl.setPlaceholder((Node)new Label(expTgtPlaceHolderStr));
        this.constraintRuleSetTbl.setPlaceholder((Node)new Label(ruleSetPlaceHolderStr));
        this.objectiveRuleSetTbl.setPlaceholder((Node)new Label(ruleSetPlaceHolderStr));
        this.evBroker.addListener((IEventListener)this, true);
    }

    protected void populateSolverCombos() {
        Set cBackends = this.dbsService.getDSEBackends(this.selectedSynthesises, IDSEBackend.EXPLORATION_TYPE.FEASIBILITY_CHECK);
        this.feasibilitySolverCombo.setItems(FXCollections.observableArrayList((Collection)cBackends));
        if (!cBackends.isEmpty()) {
            this.feasibilitySolverCombo.setConverter(this.createTargetComboConverter(this.feasibilitySolverCombo));
            this.feasibilitySolverCombo.getSelectionModel().select(0);
        }
        Set oBackends = this.dbsService.getDSEBackends(this.selectedSynthesises, IDSEBackend.EXPLORATION_TYPE.OPTIMIZATION);
        this.optimalitySolverCombo.setItems(FXCollections.observableArrayList((Collection)oBackends));
        if (!oBackends.isEmpty()) {
            this.optimalitySolverCombo.setConverter(this.createTargetComboConverter(this.optimalitySolverCombo));
            this.optimalitySolverCombo.getSelectionModel().select(0);
        }
    }

    protected StringConverter<IDSEBackend> createTargetComboConverter(final ComboBox<IDSEBackend> combo) {
        return new StringConverter<IDSEBackend>(){

            public String toString(IDSEBackend object) {
                return object != null ? object.getName() : "";
            }

            public IDSEBackend fromString(String string) {
                return combo.getItems().stream().filter(ap -> ap.getName().equals(string)).findFirst().orElse(null);
            }
        };
    }

    protected SolverSettings getSolverSettings(IDSEBackend selectedBackend) {
        SolverSettings settings = this.solverSettings.get(selectedBackend.getClass());
        if (settings == null) {
            settings = selectedBackend.getSolverSettings();
            this.solverSettings.put(selectedBackend.getClass(), settings);
        }
        return settings;
    }

    protected void setSolverSettings(IDSEBackend selectedBackend, SolverSettings settings) {
        this.solverSettings.put(selectedBackend.getClass(), settings);
    }

    protected void loadSolverSettings() {
        ProcessStep pStep = this.getActiveDse().getCurrentStep();
        if (pStep instanceof ExplorationStep) {
            ((ExplorationStep)pStep).getSolverSettings().forEach(setting -> {
                SolverSettings solverSettings = this.solverSettings.put((Class)setting.getKey(), (SolverSettings)setting.getValue());
            });
        }
    }

    protected <T extends IExplorationTarget<?>> DynamicTreeTableViewer<T> setupExplorationTargetListings(TreeTableView<T> tableView, Class<?> targetType) {
        Supplier<Stream> availConstraints = () -> this.availTargets.stream().filter(tgt -> targetType.isAssignableFrom(tgt.getClass()));
        DynamicTreeTableViewer dtv = new DynamicTreeTableViewer(tableView, availConstraints, new SynthesisCategoryExplorationTargetContentProvider(targetType), (DynamicTreeTableUIProviderBase)new DynamicTreeTableNameProvider<T>(){

            public ContextMenu createContextMenu(T element, int column) {
                return TreeContextMenuItem.createTreeContextMenu(Collections.singletonList(RemoveElementContextMenuItem.class), element);
            }
        });
        dtv.addColumn("Name", 400);
        tableView.getSelectionModel().getSelectedItems().addListener(new ListChangeListener<TreeItem<T>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<T>> c) {
                SynthesisFXContentController.this.enableTargetRuleSetDisableButtons();
            }
        });
        return dtv;
    }

    protected DynamicTreeTableViewer<RuleSet> setupRuleSetListings(TreeTableView<RuleSet> tableView, Class<?> targetType) {
        Supplier<Stream> filteredRuleSets = () -> this.availRuleSets.stream().filter(rS -> targetType.isAssignableFrom(((IExplorationTarget)rS.getExplorationTargets().get(0)).getClass()));
        DynamicTreeTableViewer dtv = new DynamicTreeTableViewer(tableView, filteredRuleSets, (DynamicStreamContentProvider)new SynthesisCategoryRuleSetContentProvider(targetType), (DynamicTreeTableUIProviderBase)new RuleSetUIProvider());
        dtv.addColumn("Name", 300);
        dtv.addColumn("Author", 100);
        dtv.addColumn("Date of Creation", 200);
        tableView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<RuleSet>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<RuleSet>> c) {
                c.next();
                for (TreeItem added : c.getAddedSubList()) {
                    SynthesisFXContentController.this.evBroker.firePropertyChanged(added.getValue(), IEventListener.DSE_EVENT.RULE_SET_SELECTED);
                }
                for (TreeItem removed : c.getRemoved()) {
                    SynthesisFXContentController.this.evBroker.firePropertyChanged(removed.getValue(), IEventListener.DSE_EVENT.RULE_SET_DESELECTED);
                }
                SynthesisFXContentController.this.enableTargetRuleSetDisableButtons();
            }
        });
        return dtv;
    }

    protected Collection<IExplorationConstraint<?>> getSelectedConstraints() {
        return this.constraintTbl.getSelectionModel().getSelectedItems().stream().map(item -> (IExplorationConstraint)item.getValue()).collect(Collectors.toList());
    }

    protected Collection<IExplorationObjective<?>> getSelectedObjectives() {
        return this.objectiveTbl.getSelectionModel().getSelectedItems().stream().map(item -> (IExplorationObjective)item.getValue()).collect(Collectors.toList());
    }

    protected Set<RuleSet> getSelectedConstraintRuleSets() {
        return this.constraintRuleSetTbl.getSelectionModel().getSelectedItems().stream().map(item -> (RuleSet)item.getValue()).collect(Collectors.toSet());
    }

    protected Set<RuleSet> getSelectedObjectiveRuleSets() {
        return this.objectiveRuleSetTbl.getSelectionModel().getSelectedItems().stream().map(item -> (RuleSet)item.getValue()).collect(Collectors.toSet());
    }

    public void onCreateConstraintRuleSet() {
        Collection<IExplorationConstraint<?>> selConstraints = this.getSelectedConstraints();
        this.createRuleSetUI(selConstraints, true);
    }

    protected void createRuleSetUI(Collection<? extends IExplorationTarget<?>> selTargets, boolean isConstraint) {
        if (!selTargets.isEmpty()) {
            String name = "New " + (isConstraint ? "Constraint" : "Objective") + " RuleSet";
            if (isConstraint) {
                if (cstrRsCnt++ > 0) {
                    name = name + " " + cstrRsCnt;
                }
            } else if (objRsCnt++ > 0) {
                name = name + " " + objRsCnt;
            }
            RuleSet ruleSet = DSEProjectModelElementFactory.createRuleSet((String)name, (String)"DSE User", (String)"");
            ruleSet.getExplorationTargets().addAll(selTargets);
            DSE activeDse = this.getActiveDse();
            ProcessStep pStep = activeDse.getCurrentStep();
            if (!(pStep instanceof TargetDefinitionStep)) {
                this.runner.run(() -> activeDse.addProcessStep((ProcessStep)DSEProjectModelElementFactory.createTargetDefinitionStep((String)"Target Definition")));
                pStep = activeDse.getCurrentStep();
            }
            TargetDefinitionStep tDefStep = (TargetDefinitionStep)pStep;
            UniqueIDUtils.prepareUniqueID((EObject)ruleSet, (EObject)pStep);
            this.runner.run(() -> {
                boolean bl = tDefStep.getDefinedRuleSets().add((Object)ruleSet);
            });
            this.evBroker.firePropertyChanged(ruleSet, IEventListener.DSE_EVENT.RULE_SET_ADDED);
        }
    }

    private void addTargetRuleSet(Set<RuleSet> ruleSets, Collection<? extends IExplorationTarget<?>> selectedTargets) {
        for (RuleSet rS : ruleSets) {
            if (!EcoreUtils.getAllReferences((EObject)rS).isEmpty()) continue;
            boolean changed = false;
            for (IExplorationTarget<?> target : selectedTargets) {
                if (rS.getExplorationTargets().contains(target)) continue;
                this.runner.run(() -> {
                    boolean bl = rS.getExplorationTargets().add((Object)target);
                });
                changed = true;
            }
            if (!changed) continue;
            this.evBroker.firePropertyChanged(rS, IEventListener.DSE_EVENT.RULE_SET_CHANGED);
        }
    }

    public void onAddConstraintRuleSet() {
        this.addTargetRuleSet(this.getSelectedConstraintRuleSets(), this.getSelectedConstraints());
    }

    private void removeTargetRuleSet(Set<RuleSet> ruleSets, Collection<? extends IExplorationTarget<?>> selectedTargets) {
        for (RuleSet rS : ruleSets) {
            if (!EcoreUtils.getAllReferences((EObject)rS).isEmpty()) continue;
            boolean changed = false;
            for (IExplorationTarget<?> target : selectedTargets) {
                if (!rS.getExplorationTargets().contains(target)) continue;
                this.runner.run(() -> {
                    boolean bl = rS.getExplorationTargets().remove((Object)target);
                });
                changed = true;
            }
            if (!changed) continue;
            this.evBroker.firePropertyChanged(rS, IEventListener.DSE_EVENT.RULE_SET_CHANGED);
        }
    }

    public void onRemoveConstraintRuleSet() {
        this.removeTargetRuleSet(this.getSelectedConstraintRuleSets(), this.getSelectedConstraints());
    }

    public void onCreateObjectiveRuleSet() {
        Collection<IExplorationObjective<?>> selObjectives = this.getSelectedObjectives();
        this.createRuleSetUI(selObjectives, false);
    }

    public void onAddObjectiveRuleSet() {
        this.addTargetRuleSet(this.getSelectedObjectiveRuleSets(), this.getSelectedObjectives());
    }

    public void onRemoveObjectiveRuleSet() {
        this.removeTargetRuleSet(this.getSelectedObjectiveRuleSets(), this.getSelectedObjectives());
    }

    public void onCheckFeasibility() {
        IDSEBackend selectedBackend = (IDSEBackend)this.feasibilitySolverCombo.getValue();
        this.executeExploration(selectedBackend, this.getSelectedConstraintRuleSets(), this.getSolverSettings(selectedBackend));
    }

    public void onOptimize() {
        IDSEBackend selectedBackend = (IDSEBackend)this.optimalitySolverCombo.getValue();
        HashSet<RuleSet> selectedRuleSets = new HashSet<RuleSet>();
        selectedRuleSets.addAll(this.getSelectedConstraintRuleSets());
        selectedRuleSets.addAll(this.getSelectedObjectiveRuleSets());
        this.executeExploration(selectedBackend, selectedRuleSets, this.getSolverSettings(selectedBackend));
    }

    protected void executeExploration(IDSEBackend selectedBackend, Set<RuleSet> selectedRuleSets, SolverSettings settings) {
        String expName = this.selectedSynthesises.stream().map(syn -> this.dbsService.getSynthesisName(syn)).collect(Collectors.joining(", ")) + " Exploration";
        ExplorationStep expStep = DSEProjectModelElementFactory.createExplorationStep((String)expName, selectedRuleSets, this.solverSettings);
        ExplorationCommandRunner.getRunner().run(() -> this.getActiveDse().addProcessStep((ProcessStep)expStep));
        this.evBroker.firePropertyChanged(expStep, IEventListener.DSE_EVENT.PROCESS_STEP_ADDED);
        ExplorationSpecification expSpec = ExplorationModelElementFactory.createExplorationSpecification();
        expSpec.getTargets().addAll(ExplorationUtils.convertRuleSetsToExplorationSpec((Collection)EcoreUtils.pickInstanceOf(RuleSet.class, (List)expStep.getSystemConstraintSets()), this.selectedSynthesises));
        expSpec.getTargets().addAll(ExplorationUtils.convertRuleSetsToExplorationSpec(selectedRuleSets, this.selectedSynthesises));
        SuperSetMap superSets = (SuperSetMap)EcoreUtils.copy((EObject)this.getActiveDse().getCurrentStep().getSuperSetMap());
        expSpec.setSearchSpace(superSets);
        expSpec.getSynthTypes().addAll(this.selectedSynthesises);
        try {
            this.dbsService.explore(selectedBackend, expSpec, settings, this.createDSEResultAdapter(expSpec));
        }
        catch (Exception ex) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"Error executing the DSE.", (Throwable)ex);
            LoggingUtils.showError((String)("Error executing the DSE: " + ex.getMessage()));
        }
    }

    protected final DSEJobAdapter createDSEResultAdapter(ExplorationSpecification expSpec) {
        return new DSEJobAdapter(expSpec){

            /*
             * Enabled aggressive block sorting
             */
            public void done(IJobChangeEvent event) {
                SynthesisFXContentController.this.useResults = false;
                IStatus result = event.getResult();
                Optional solution = this.getSolution();
                if (result.isOK()) {
                    SynthesisFXContentController.this.useResults = true;
                } else if (result.matches(8)) {
                    if (!solution.isPresent()) {
                        MessageUtilsExtended.showWarningInUIThread((String)"Error", (String)"The DSE has been cancelled before any solution has been found.");
                        return;
                    }
                    SynthesisFXContentController.this.useResults = MessageUtilsExtended.askQuestionInUIThread((String)"View Solutions?", (String)"The DSE has been cancelled. Do you want to visualize the already found suboptimal solutions?");
                } else {
                    Throwable e = result.getException();
                    MessageUtilsExtended.showErrorInUIThread((String)"Error", (String)("An error as occurred when executing the DSE: " + (e != null ? e.getMessage() : "<no cause provided>")));
                    return;
                }
                if (!solution.isPresent()) {
                    MessageUtilsExtended.showErrorInUIThread((String)"Error", (String)"Due to an error, the DSE did not yield a solution.");
                    return;
                }
                if (!SynthesisFXContentController.this.useResults) return;
                SynthesisFXContentController.this.processResults((ExplorationSolution)solution.get());
            }
        };
    }

    private void processResults(ExplorationSolution solution) {
        SolutionState solutionState = solution.getSolutionState();
        this.evBroker.firePropertyChanged(solution, IEventListener.DSE_EVENT.UNSAT_CORES_UPDATE);
        if (solutionState == SolutionState.UNSAT) {
            MessageUtilsExtended.showErrorInUIThread((String)"Problem not solvable.", (String)"Please relax your constraint sets in order to get a solvable model.");
            return;
        }
        if (solutionState == SolutionState.UNKNOWN && solution.getSolutions().isEmpty()) {
            LoggingUtils.showInfo((String)"The DSE backend did not find a solution to the specified problem:\n\nThe run was either cancelled or the given timeout was reached before a solution was found (or infeasibility was detected).");
            return;
        }
        DSE activeDse = this.getActiveDse();
        ExplorationStep currentStep = (ExplorationStep)activeDse.getCurrentStep();
        ExplorationCommandRunner.getRunner().run(() -> {
            currentStep.setSolution(solution);
            UniqueIDUtils.prepareIDs((EObject)currentStep, (EObject)activeDse, (int)UniqueIDUtils.getLargestID((EObject)activeDse));
        });
        if (solution.getSolutionState() == SolutionState.OPTIMIZED) {
            LoggingUtils.showInfo((String)"Solution found.\n\nThe solver returned an optimized but non-optimal solution (Timeout, number of iterations. Please note that \"better\" solutions may exist.");
        }
    }

    protected void updateExplorationTargetRuleSetTables() {
        this.constraintView.update();
        this.constraintRuleSetTbl.refresh();
        this.objectiveView.update();
        this.constraintRuleSetView.update();
        this.objectiveRuleSetView.update();
    }

    @FXML
    public void onFeasibilitySolverSettings() {
        this.editSolverSettings((IDSEBackend)this.feasibilitySolverCombo.getValue());
    }

    @FXML
    public void onOptimalitySolverSettings() {
        this.editSolverSettings((IDSEBackend)this.optimalitySolverCombo.getValue());
    }

    protected void editSolverSettings(IDSEBackend selectedBackend) {
        SolverSettings settings = this.getSolverSettings((IDSEBackend)this.optimalitySolverCombo.getValue());
        SolverSettingsDialog dialog = new SolverSettingsDialog(settings);
        dialog.showAndWait();
        this.setSolverSettings(selectedBackend, (SolverSettings)dialog.getResult());
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        if (this.getActiveDse() == null) {
            return;
        }
        switch (event) {
            case EXP_TARGET_ADDED: 
            case EXP_TARGET_REMOVED: 
            case RULE_SET_ADDED: 
            case RULE_SET_REMOVED: 
            case RULE_SET_CHANGED: {
                this.updateTargetRuleSetLists();
                this.updateExplorationTargetRuleSetTables();
                break;
            }
            case RULE_SET_SELECTED: {
                this.selectedRuleSets.add((RuleSet)source);
                this.updateTargetSelection();
                break;
            }
            case RULE_SET_DESELECTED: {
                this.selectedRuleSets.remove(source);
                this.updateTargetSelection();
                break;
            }
            case SYNTH_CAT_ADDED: {
                List added = (List)source;
                this.selectedSynthesises.addAll(added);
                this.populateSolverCombos();
                this.updateExplorationTargetRuleSetTables();
                this.enableTargetRuleSetDisableButtons();
                break;
            }
            case SYNTH_CAT_REMOVED: {
                List removed = (List)source;
                this.selectedSynthesises.removeAll(removed);
                this.populateSolverCombos();
                this.updateExplorationTargetRuleSetTables();
                this.enableTargetRuleSetDisableButtons();
                break;
            }
            case DSE_SELECTED_EVENT: {
                this.updateTargetRuleSetLists();
                this.populateTargetRuleSetTables();
                this.populateSolverCombos();
                this.loadSolverSettings();
                break;
            }
            case PROCESS_STEP_REMOVED: 
            case PROCESS_STEP_SELECTED: {
                this.updateTargetRuleSetLists();
                this.updateExplorationTargetRuleSetTables();
                this.enableTargetRuleSetDisableButtons();
                break;
            }
            case DSE_REMOVED_EVENT: {
                Platform.runLater(() -> {
                    this.constraintTbl.setRoot(null);
                    this.constraintRuleSetTbl.setRoot(null);
                    this.objectiveTbl.setRoot(null);
                    this.objectiveRuleSetTbl.setRoot(null);
                    this.constraintTbl.getColumns().clear();
                    this.constraintRuleSetTbl.getColumns().clear();
                    this.objectiveTbl.getColumns().clear();
                    this.objectiveRuleSetTbl.getColumns().clear();
                });
            }
        }
    }

    private void updateTargetSelection() {
        this.constraintView.clearSelection();
        this.objectiveView.clearSelection();
        for (RuleSet ruleSet : this.selectedRuleSets) {
            EList tgts = ruleSet.getExplorationTargets();
            this.constraintView.selectValues((List)EcoreUtils.pickInstanceOf(IExplorationConstraint.class, (List)tgts));
            this.objectiveView.selectValues((List)EcoreUtils.pickInstanceOf(IExplorationObjective.class, (List)tgts));
        }
    }

    private boolean hasMatchingTargets(Class<? extends IExplorationTarget> type) {
        return this.availTargets.stream().filter(tgt -> type.isAssignableFrom(tgt.getClass())).filter(tgt -> this.selectedSynthesises.containsAll((Collection<?>)tgt.getSynthesisCategories())).findFirst().isPresent();
    }

    private void enableTargetRuleSetDisableButtons() {
        this.enableTargetRuleSetDisableButtons(IExplorationConstraint.class, this.getSelectedConstraintRuleSets(), this.getSelectedConstraints(), this.createConstraintRuleSetBtn, this.addConstraintRuleSetBtn, this.removeConstraintRuleSetBtn);
        this.enableTargetRuleSetDisableButtons(IExplorationObjective.class, this.getSelectedObjectiveRuleSets(), this.getSelectedObjectives(), this.createObjectiveRuleSetBtn, this.addObjectiveRuleSetBtn, this.removeObjectiveRuleSetBtn);
    }

    private void enableTargetRuleSetDisableButtons(Class<? extends IExplorationTarget> type, Set<RuleSet> ruleSets, Collection<? extends IExplorationTarget<?>> targets, Button createButton, Button addButton, Button removeButton) {
        boolean synthesisMatchingTargets = this.hasMatchingTargets(type);
        boolean mayAddTargets = !targets.isEmpty();
        for (IExplorationTarget<?> t : targets) {
            EObject targetScope = t.eContainer();
            if (!ruleSets.stream().anyMatch(r -> r.getExplorationTargets().contains((Object)t) || !EcoreUtils.isAncestor((EObject)r, (EObject)targetScope))) continue;
            mayAddTargets = false;
            break;
        }
        boolean mayRemoveTargets = !targets.isEmpty();
        for (IExplorationTarget<?> c : targets) {
            if (ruleSets.stream().allMatch(r -> r.getExplorationTargets().contains((Object)c))) continue;
            mayRemoveTargets = false;
            break;
        }
        ruleSets.removeIf(r -> !EcoreUtils.getAllReferences((EObject)r).isEmpty());
        createButton.setDisable(!synthesisMatchingTargets || targets.isEmpty());
        addButton.setDisable(!synthesisMatchingTargets || ruleSets.isEmpty() || !mayAddTargets);
        removeButton.setDisable(!synthesisMatchingTargets || ruleSets.isEmpty() || !(mayRemoveTargets &= !ruleSets.stream().anyMatch(r -> r.getExplorationTargets().size() == targets.size())));
    }
}

