/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.synthesis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.ui.perspective.generic.ExplorationUIFXController;
import org.fortiss.af3.exploration.ui.perspective.generic.ExplorationUIFXViewPart;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.synthesis.SynthesisFXContentController;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;

public class SynthesisFXViewPart
extends ExplorationUIFXViewPart {
    protected final Map<String, Class<? extends ISynthesisCategory>> synthCategoryMapping = new HashMap<String, Class<? extends ISynthesisCategory>>();
    protected final List<String> synthCategoryNames;
    protected final IDSEBackendService dseBackendSrv = IDSEBackendService.getInstance();
    protected final EventBroker evBroker = EventBroker.getInstance();
    private static Set<Class<? extends ISynthesisCategory>> selectedSyntheses = new HashSet<Class<? extends ISynthesisCategory>>();
    private CheckComboBox<String> synthesisTypeCheckComboBox;

    public SynthesisFXViewPart() throws Exception {
        super((ICompositeFXController<? extends Node, ?>)new ExplorationUIFXController<HBox>((ICompositeFXController<Node, ?>)new SynthesisFXContentController(), new HBox()), "synthesis_icon.gif", null);
        ArrayList synthCategories = new ArrayList(this.dseBackendSrv.getDSESynthesises());
        synthCategories.stream().forEach(c -> {
            Class<? extends ISynthesisCategory> clazz = this.synthCategoryMapping.put(this.dseBackendSrv.getSynthesisName(c), (Class<? extends ISynthesisCategory>)c);
        });
        this.synthCategoryNames = this.synthCategoryMapping.keySet().stream().collect(Collectors.toList());
        Collections.sort(this.synthCategoryNames);
        if (!this.synthCategoryNames.isEmpty()) {
            Class<? extends ISynthesisCategory> cat = this.synthCategoryMapping.get(this.synthCategoryNames.get(0));
            selectedSyntheses.add(cat);
        }
        HBox titleBox = (HBox)((ExplorationUIFXController)this.controller).getTitleNode();
        this.createSynthSelectionNode(titleBox);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        for (Class<? extends ISynthesisCategory> synth : selectedSyntheses) {
            this.synthesisTypeCheckComboBox.getCheckModel().check((Object)this.dseBackendSrv.getSynthesisName(synth));
        }
    }

    protected void createSynthSelectionNode(HBox titleBox) {
        titleBox.setAlignment(Pos.CENTER);
        this.synthesisTypeCheckComboBox = new CheckComboBox(FXCollections.observableList(this.synthCategoryNames));
        titleBox.getChildren().add(this.synthesisTypeCheckComboBox);
        Label titleLbl = new Label(" Synthesis");
        titleLbl.setAlignment(Pos.CENTER);
        titleLbl.setFont(new Font("System Bold", 36.0));
        titleBox.getChildren().add((Object)titleLbl);
        this.synthesisTypeCheckComboBox.getCheckModel().getCheckedItems().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        Collection added = c.getAddedSubList().stream().map(str -> SynthesisFXViewPart.this.synthCategoryMapping.get(str)).collect(Collectors.toList());
                        SynthesisFXViewPart.this.evBroker.firePropertyChanged(added, IEventListener.DSE_EVENT.SYNTH_CAT_ADDED);
                        selectedSyntheses.addAll(added);
                        continue;
                    }
                    if (!c.wasRemoved()) continue;
                    Collection removed = c.getRemoved().stream().map(str -> SynthesisFXViewPart.this.synthCategoryMapping.get(str)).collect(Collectors.toList());
                    SynthesisFXViewPart.this.evBroker.firePropertyChanged(removed, IEventListener.DSE_EVENT.SYNTH_CAT_REMOVED);
                    selectedSyntheses.removeAll(removed);
                }
            }
        });
    }

    @Override
    public IProcessManager.EProcessStep getProcessStep() {
        return IProcessManager.EProcessStep.SYNTHESIS;
    }
}

