/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef;

import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.InputEvent;
import javafx.scene.layout.Pane;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class PatternContainerFXController
extends CompositeFXControllerBase<TitledPane, Node>
implements IEventListener {
    @FXML
    private TitledPane patternTitledPane;
    @FXML
    private TextField patternName;
    @FXML
    private TextField patternCategory;
    @FXML
    private Label patternDescription;
    @FXML
    private Pane patternInterface;
    @FXML
    private Button patternButton;
    protected DSE selectedDSE;
    private PatternFXControllerBase patternController;

    public PatternContainerFXController(PatternFXControllerBase patternController) {
        super(new ICompositeFXController[]{patternController});
        this.patternController = patternController;
    }

    @FXML
    protected void onMouseClicked() {
        if (!this.patternController.isFullySpecified()) {
            MessageUtils.showInfo((String)"Incomplete pattern specification", (String)"Check whether all of the pattern's input fields have been filled out!");
            return;
        }
        IDSEPerspectiveManager pm = IDSEPerspectiveManager.INSTANCE;
        IExplorationTarget expTgt = this.patternController.getExplorationTarget();
        UniqueIDUtils.prepareUniqueID((EObject)this.selectedDSE, (EObject)this.selectedDSE);
        pm.addExplorationTarget(expTgt);
    }

    public String getFXMLLocation() {
        return "PatternLayout.fxml";
    }

    public void initialize() {
        Node patternLayout = this.patternController.getLayout();
        this.patternInterface.getChildren().add((Object)patternLayout);
        this.fitToParent(patternLayout);
        this.patternController.getControls().forEach(control -> control.addEventHandler(InputEvent.ANY, (EventHandler)new EventHandler<InputEvent>(){

            public void handle(InputEvent event) {
                PatternContainerFXController.this.patternName.setText(String.join((CharSequence)", ", PatternContainerFXController.this.patternController.getExplorationTargetName()));
            }
        }));
        this.patternTitledPane.setText(this.patternController.getPatternName());
        this.patternCategory.setText(this.patternController.getCategory());
        this.patternDescription.setText(this.patternController.getDescription());
        if (IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE() != null) {
            this.patternName.setText(String.join((CharSequence)", ", this.patternController.getExplorationTargetName()));
        }
        this.patternName.setEditable(false);
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        switch (event) {
            case DSE_SELECTED_EVENT: {
                this.selectedDSE = (DSE)source;
                this.patternButton.setDisable(false);
                break;
            }
            case DSE_REMOVED_EVENT: {
                this.selectedDSE = null;
                this.patternButton.setDisable(true);
            }
        }
    }
}

