/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef;

import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.targetdef.IPatternFXController;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;

public abstract class PatternFXControllerBase
extends CompositeFXControllerBase<TitledPane, Node>
implements IPatternFXController {
    private DSE selectedDse;

    protected PatternFXControllerBase() {
        super(new ICompositeFXController[0]);
    }

    public void initialize() {
        EventBroker.getInstance().addListener(this);
        this.selectedDse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        if (this.selectedDse != null) {
            this.setupViews();
        }
    }

    @Override
    public void destroyViews() {
        EventBroker.getInstance().removeListener(this);
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        switch (event) {
            case DSE_SELECTED_EVENT: {
                this.selectedDse = (DSE)source;
                this.setupViews();
                break;
            }
            case DSE_REMOVED_EVENT: {
                this.selectedDse = null;
                this.destroyViews();
            }
        }
    }

    protected <T extends IModelElement> Optional<SuperSet<T>> getSuperSet(Class<T> setType) {
        return Optional.of(this.selectedDse.getCurrentStep().getSuperSetMap().get(setType));
    }

    @Override
    public boolean hiddenInNonExpertView() {
        return false;
    }
}

